/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Func;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

class FuncRegistry {
    final ConcurrentMap<Integer, Func.Handler> map = new ConcurrentHashMap<Integer, Func.Handler>();
    private final AtomicInteger indexCounter = new AtomicInteger();

    FuncRegistry() {
    }

    int acquire(Func.Handler handler) {
        int index = this.indexCounter.getAndIncrement();
        this.map.put(index, handler);
        return index;
    }

    Func.Handler lookup(int index) {
        return (Func.Handler)this.map.get(index);
    }

    void drop(int index) {
        this.map.remove(index);
    }

    public String toString() {
        return "FuncRegistry(map=" + this.map + ", indexCounter=" + this.indexCounter + ")";
    }
}

