/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.Engine;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.ExternItem;
import io.github.kawamuray.wasmtime.Module;
import io.github.kawamuray.wasmtime.Store;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linker
implements Disposable {
    private static final Logger log = LoggerFactory.getLogger(Linker.class);
    private long innerPtr;

    public Linker(Engine engine) {
        this(Linker.newLinker(engine.innerPtr()));
    }

    public <T> void module(Store<T> store, String moduleName, Module module) {
        this.nativeModule(store.innerPtr(), moduleName, module.innerPtr());
    }

    public <T> void define(Store<T> store, String moduleName, String name, Extern extern) {
        this.nativeDefine(store.innerPtr(), moduleName, name, extern);
    }

    public <T> Optional<Extern> get(Store<T> store, String module, String name) {
        return Optional.ofNullable(this.nativeGet(store.innerPtr(), module, name));
    }

    public <T> Collection<ExternItem> externs(Store<T> store) {
        ExternItem[] items = this.nativeExterns(store.innerPtr());
        return Arrays.asList(items);
    }

    public <T> Collection<ExternItem> externsOfModule(Store<T> store, String module) {
        HashSet<ExternItem> items = new HashSet<ExternItem>(this.externs(store));
        items.removeIf(item -> !item.module().equals(module));
        return items;
    }

    public <T> Set<String> modules(Store<T> store) {
        HashSet<String> modules = new HashSet<String>();
        for (ExternItem item : this.externs(store)) {
            modules.add(item.module());
        }
        return modules;
    }

    @Override
    public native void dispose();

    private static native long newLinker(long var0);

    private native void nativeModule(long var1, String var3, long var4);

    private native void nativeDefine(long var1, String var3, String var4, Extern var5);

    private native Extern nativeGet(long var1, String var3, String var4);

    private native ExternItem[] nativeExterns(long var1);

    Linker(long innerPtr) {
        this.innerPtr = innerPtr;
    }

    public long innerPtr() {
        return this.innerPtr;
    }
}

