/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.configuration.JavadocConfiguration;
import io.github.kbuntrock.javadoc.ClassDocumentation;
import io.github.kbuntrock.javadoc.CommentType;
import io.github.kbuntrock.javadoc.JavadocWrapper;
import io.github.kbuntrock.utils.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class JavadocParser {
    private static final String LOG_PREFIX = JavadocParser.class.getSimpleName() + " - ";
    private final JavaParser javaParser;
    private final Log logger = Logger.INSTANCE.getLogger();
    private final Map<String, ClassDocumentation> javadocMap = new HashMap<String, ClassDocumentation>();
    private final List<File> filesToScan;
    private final JavadocVisitor visitor = new JavadocVisitor();
    private final boolean debugScan;

    public JavadocParser(List<File> filesToScan, JavadocConfiguration javadocConfiguration) {
        this.filesToScan = filesToScan;
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        parserConfiguration.setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE);
        Charset charset = StandardCharsets.UTF_8;
        if (Charset.isSupported(javadocConfiguration.getEncoding())) {
            charset = Charset.forName(javadocConfiguration.getEncoding());
        } else {
            this.logger.warn((CharSequence)("Encoding " + javadocConfiguration.getEncoding() + " is not supported. UTF-8 will be used instead."));
            this.logger.warn((CharSequence)("Supported encoding on this JVM are : " + Charset.availableCharsets().keySet().stream().collect(Collectors.joining(", "))));
        }
        parserConfiguration.setCharacterEncoding(charset);
        this.debugScan = javadocConfiguration.isDebugScan();
        this.javaParser = new JavaParser(parserConfiguration);
    }

    private static String describe(Node node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            return "Method " + methodDeclaration.getDeclarationAsString();
        }
        if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)node;
            return "Constructor " + constructorDeclaration.getDeclarationAsString();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)node;
            if (classOrInterfaceDeclaration.isInterface()) {
                return "Interface " + classOrInterfaceDeclaration.getName();
            }
            return "Class " + classOrInterfaceDeclaration.getName();
        }
        if (node instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)node;
            return "Enum " + enumDeclaration.getName();
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            List varNames = fieldDeclaration.getVariables().stream().map(v -> v.getName().getId()).collect(Collectors.toList());
            return "Field " + String.join((CharSequence)", ", varNames);
        }
        return node.toString();
    }

    public void scan() {
        for (File file : this.filesToScan) {
            if (!file.exists()) {
                this.logger.warn((CharSequence)(LOG_PREFIX + "Directory " + file.getAbsolutePath() + " does not exist."));
                continue;
            }
            if (!file.isDirectory()) {
                this.logger.warn((CharSequence)(LOG_PREFIX + "File " + file.getAbsolutePath() + " is not a directory."));
                continue;
            }
            try {
                this.logger.info((CharSequence)(LOG_PREFIX + "Scanning directory : " + file.getAbsolutePath()));
                this.exploreDirectory(file);
            }
            catch (FileNotFoundException e) {
                this.logger.error((CharSequence)(LOG_PREFIX + "Cannot read file " + file.getAbsolutePath()));
                throw new RuntimeException("Cannot read file", e);
            }
        }
        this.printDebug();
    }

    private void printDebug() {
        if (this.debugScan) {
            this.logger.debug((CharSequence)"-------- PRINT JAVADOC SCAN RESULTS ----------");
            for (ClassDocumentation classDocumentation : this.javadocMap.values()) {
                this.logger.debug((CharSequence)("Class documentation for : " + classDocumentation.getCompleteName()));
                this.logger.debug((CharSequence)("Description : " + classDocumentation.getDescription()));
                if (classDocumentation.getMethodsJavadoc().isEmpty()) continue;
                for (Map.Entry<String, JavadocWrapper> entry : classDocumentation.getMethodsJavadoc().entrySet()) {
                    this.logger.debug((CharSequence)("Method doc for : " + entry.getKey()));
                    this.logger.debug((CharSequence)("Description : " + entry.getValue().getDescription()));
                    entry.getValue().printParameters();
                    entry.getValue().printReturn();
                }
            }
        }
    }

    private void exploreDirectory(File directory) throws FileNotFoundException {
        for (File child : directory.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".java")) {
                this.exploreJavaFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.exploreDirectory(child);
        }
    }

    private void exploreJavaFile(File javaFile) throws FileNotFoundException {
        try {
            ParseResult parseResult = this.javaParser.parse(javaFile);
            if (!parseResult.isSuccessful()) {
                throw new ParseProblemException(parseResult.getProblems());
            }
            CompilationUnit compilationUnit = (CompilationUnit)parseResult.getResult().get();
            this.visitor.visit(compilationUnit, null);
        }
        catch (ParseProblemException ex) {
            Logger.INSTANCE.getLogger().warn((CharSequence)("Error while parsing javadoc of file " + javaFile.getName() + " -> " + ex.getMessage()));
        }
    }

    private Optional<ClassDocumentation> findClassDocumentationForNode(Node commentedNode) {
        ClassOrInterfaceDeclaration classDeclaration = null;
        if (commentedNode instanceof ClassOrInterfaceDeclaration) {
            classDeclaration = (ClassOrInterfaceDeclaration)commentedNode;
        } else if (commentedNode.hasParentNode() && commentedNode.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            classDeclaration = (ClassOrInterfaceDeclaration)commentedNode.getParentNode().get();
        }
        if (classDeclaration != null) {
            ClassOrInterfaceDeclaration dec = classDeclaration;
            return Optional.of(this.javadocMap.computeIfAbsent((String)dec.getFullyQualifiedName().get(), key -> new ClassDocumentation((String)dec.getFullyQualifiedName().get(), dec.getName().asString())));
        }
        if (commentedNode instanceof RecordDeclaration) {
            String fullName = (String)((RecordDeclaration)commentedNode).getFullyQualifiedName().get();
            RecordDeclaration dec = (RecordDeclaration)commentedNode;
            return Optional.of(this.javadocMap.computeIfAbsent(fullName, key -> new ClassDocumentation(fullName, dec.getName().asString())));
        }
        EnumDeclaration enumDeclaration = null;
        if (commentedNode instanceof EnumDeclaration) {
            enumDeclaration = (EnumDeclaration)commentedNode;
        } else if (commentedNode.hasParentNode() && commentedNode.getParentNode().get() instanceof EnumDeclaration) {
            enumDeclaration = (EnumDeclaration)commentedNode.getParentNode().get();
        }
        if (enumDeclaration != null) {
            EnumDeclaration dec = enumDeclaration;
            return Optional.of(this.javadocMap.computeIfAbsent((String)dec.getFullyQualifiedName().get(), key -> new ClassDocumentation((String)dec.getFullyQualifiedName().get(), dec.getName().asString())));
        }
        return Optional.empty();
    }

    public Map<String, ClassDocumentation> getJavadocMap() {
        return this.javadocMap;
    }

    private class JavadocVisitor
    extends VoidVisitorAdapter {
        private JavadocVisitor() {
        }

        public void visit(JavadocComment comment, Object arg) {
            Optional classDocumentation;
            super.visit(comment, arg);
            CommentType type = CommentType.fromNode((Node)comment.getCommentedNode().get());
            if (CommentType.OTHER != type && (classDocumentation = JavadocParser.this.findClassDocumentationForNode((Node)comment.getCommentedNode().get())).isPresent()) {
                Javadoc javadoc = comment.parse();
                switch (type) {
                    case CLASS: {
                        ((ClassDocumentation)classDocumentation.get()).setJavadoc(javadoc);
                        break;
                    }
                    case FIELD: {
                        ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put(((FieldDeclaration)comment.getCommentedNode().get()).getVariable(0).getNameAsString(), new JavadocWrapper(javadoc));
                        break;
                    }
                    case RECORD: {
                        ((ClassDocumentation)classDocumentation.get()).setJavadoc(javadoc);
                        for (JavadocBlockTag parameter : javadoc.getBlockTags()) {
                            if (parameter.getContent().isEmpty() || !parameter.getName().isPresent()) continue;
                            ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put((String)parameter.getName().get(), new JavadocWrapper(new Javadoc(parameter.getContent())));
                        }
                        break;
                    }
                    case ENUM_VALUE: {
                        ((ClassDocumentation)classDocumentation.get()).getFieldsJavadoc().put(((EnumConstantDeclaration)comment.getCommentedNode().get()).getNameAsString(), new JavadocWrapper(javadoc));
                        break;
                    }
                    case METHOD: {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)comment.getCommentedNode().get();
                        StringBuilder sb = new StringBuilder();
                        sb.append(methodDeclaration.getType().asString());
                        sb.append("_");
                        sb.append(methodDeclaration.getName().asString());
                        for (Parameter parameter : methodDeclaration.getParameters()) {
                            sb.append("_");
                            sb.append(parameter.getType().asString());
                        }
                        ((ClassDocumentation)classDocumentation.get()).getMethodsJavadoc().put(sb.toString(), new JavadocWrapper(javadoc));
                    }
                }
            }
        }
    }
}

