/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.javadoc;

import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.github.kbuntrock.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JavadocWrapper {
    private static final String INHERIT_DOC_TAG_NAME = "inheritDoc";
    private static String endOfLineReplacement = null;
    private final Javadoc javadoc;
    private Map<JavadocBlockTag.Type, List<JavadocBlockTag>> blockTagsByType;
    private Map<String, JavadocBlockTag> paramBlockTagsByName;
    private boolean inheritTagFound = false;
    private boolean sortDone = false;

    public JavadocWrapper(Javadoc javadoc) {
        this.javadoc = javadoc;
    }

    public static void setEndOfLineReplacement(String endOfLineReplacement) {
        JavadocWrapper.endOfLineReplacement = endOfLineReplacement;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public void sortTags() {
        if (this.sortDone) {
            return;
        }
        this.sortDone = true;
        this.blockTagsByType = new HashMap<JavadocBlockTag.Type, List<JavadocBlockTag>>();
        this.paramBlockTagsByName = new HashMap<String, JavadocBlockTag>();
        for (JavadocBlockTag blockTag : this.javadoc.getBlockTags()) {
            List list = this.blockTagsByType.computeIfAbsent(blockTag.getType(), k -> new ArrayList());
            list.add(blockTag);
            if (JavadocBlockTag.Type.PARAM == blockTag.getType() && blockTag.getName().isPresent()) {
                this.paramBlockTagsByName.put((String)blockTag.getName().get(), blockTag);
                continue;
            }
            if (JavadocBlockTag.Type.UNKNOWN != blockTag.getType() || !INHERIT_DOC_TAG_NAME.equals(blockTag.getTagName())) continue;
            this.inheritTagFound = true;
        }
    }

    public Optional<JavadocBlockTag> getParamBlockTagByName(String parameterName) {
        return Optional.ofNullable(this.paramBlockTagsByName.get(parameterName));
    }

    public Optional<JavadocBlockTag> getReturnBlockTag() {
        List<JavadocBlockTag> list = this.blockTagsByType.get(JavadocBlockTag.Type.RETURN);
        if (list != null && !list.isEmpty()) {
            return Optional.of(list.get(0));
        }
        return Optional.empty();
    }

    public Optional<String> getDescription() {
        if (this.javadoc.getDescription() != null) {
            String desc = this.javadoc.getDescription().toText();
            if (endOfLineReplacement != null) {
                desc = desc.replaceAll("\\r\\n", endOfLineReplacement).replaceAll("\\n", endOfLineReplacement);
            }
            if (!desc.isEmpty()) {
                return Optional.of(desc);
            }
        }
        return Optional.empty();
    }

    public boolean isInheritTagFound() {
        return this.inheritTagFound;
    }

    public void printParameters() {
        if (this.paramBlockTagsByName != null && !this.paramBlockTagsByName.isEmpty()) {
            Logger.INSTANCE.getLogger().debug((CharSequence)"Parameters : ");
            for (Map.Entry<String, JavadocBlockTag> entry : this.paramBlockTagsByName.entrySet()) {
                Logger.INSTANCE.getLogger().debug((CharSequence)(entry.getKey() + " : " + entry.getValue().getContent().toText()));
            }
        }
    }

    public void printReturn() {
        Optional<JavadocBlockTag> returnTag;
        if (this.blockTagsByType != null && (returnTag = this.getReturnBlockTag()).isPresent()) {
            Logger.INSTANCE.getLogger().debug((CharSequence)("Return : " + returnTag.get().getContent().toText()));
        }
    }
}

