/*
 * Decompiled with CFR 0.152.
 */
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.session.CommandButton;
import androidx.media3.session.MediaSession;
import androidx.media3.session.MediaSessionService;
import androidx.media3.session.SessionCommand;
import androidx.media3.session.SessionCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.multiplatform.library.template.R;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020$H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"LPlaybackService;", "Landroidx/media3/session/MediaSessionService;", "<init>", "()V", "mediaSession", "Landroidx/media3/session/MediaSession;", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "customCommandSeekBackward", "Landroidx/media3/session/SessionCommand;", "customCommandSeekForward", "onCreate", "", "onGetSession", "controllerInfo", "Landroidx/media3/session/MediaSession$ControllerInfo;", "onTaskRemoved", "rootIntent", "Landroid/content/Intent;", "onDestroy", "onConnect", "Landroidx/media3/session/MediaSession$ConnectionResult;", "session", "controller", "createSeekBackwardButton", "Landroidx/media3/session/CommandButton;", "command", "createSeekForwardButton", "serializeMediaItems", "", "mediaItems", "", "Landroidx/media3/common/MediaItem;", "deserializeMediaItems", "json", "restorePlaylist", "Landroidx/media3/session/MediaSession$MediaItemsWithStartPosition;", "mediaplayer-kmp_release"})
@UnstableApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMediaPlayerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaPlayerService.kt\nPlaybackService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,156:1\n1557#2:157\n1628#2,3:158\n1557#2:163\n1628#2,3:164\n113#3:161\n147#4:162\n*S KotlinDebug\n*F\n+ 1 MediaPlayerService.kt\nPlaybackService\n*L\n103#1:157\n103#1:158,3\n109#1:163\n109#1:164,3\n104#1:161\n108#1:162\n*E\n"})
public final class PlaybackService
extends MediaSessionService {
    @Nullable
    private MediaSession mediaSession;
    private ExoPlayer player;
    @NotNull
    private final SessionCommand customCommandSeekBackward = new SessionCommand("seekBackward", new Bundle());
    @NotNull
    private final SessionCommand customCommandSeekForward = new SessionCommand("seekForward", new Bundle());
    public static final int $stable = 8;

    public void onCreate() {
        super.onCreate();
        this.player = new ExoPlayer.Builder((Context)this).build();
        Context context = (Context)this;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            exoPlayer = null;
        }
        this.mediaSession = new MediaSession.Builder(context, (Player)exoPlayer).build();
    }

    @Nullable
    public MediaSession onGetSession(@NotNull MediaSession.ControllerInfo controllerInfo) {
        Intrinsics.checkNotNullParameter((Object)controllerInfo, (String)"controllerInfo");
        return this.mediaSession;
    }

    public void onTaskRemoved(@Nullable Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"player");
            exoPlayer = null;
        }
        if (exoPlayer.getPlayWhenReady()) {
            ExoPlayer exoPlayer2 = this.player;
            if (exoPlayer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"player");
                exoPlayer2 = null;
            }
            exoPlayer2.pause();
        }
        this.stopSelf();
    }

    public void onDestroy() {
        block0: {
            super.onDestroy();
            MediaSession mediaSession = this.mediaSession;
            if (mediaSession == null) break block0;
            MediaSession $this$onDestroy_u24lambda_u240 = mediaSession;
            boolean bl = false;
            $this$onDestroy_u24lambda_u240.getPlayer().release();
            $this$onDestroy_u24lambda_u240.release();
            this.mediaSession = null;
        }
    }

    @NotNull
    public final MediaSession.ConnectionResult onConnect(@NotNull MediaSession session, @NotNull MediaSession.ControllerInfo controller) {
        MediaSession.ConnectionResult connectionResult;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        SessionCommands sessionCommands = MediaSession.ConnectionResult.DEFAULT_SESSION_AND_LIBRARY_COMMANDS.buildUpon().add(this.customCommandSeekBackward).add(this.customCommandSeekForward).build();
        Intrinsics.checkNotNullExpressionValue((Object)sessionCommands, (String)"build(...)");
        SessionCommands sessionCommands2 = sessionCommands;
        if (session.isMediaNotificationController(controller)) {
            Player.Commands commands = MediaSession.ConnectionResult.DEFAULT_PLAYER_COMMANDS.buildUpon().remove(7).remove(6).remove(9).remove(8).build();
            Intrinsics.checkNotNullExpressionValue((Object)commands, (String)"build(...)");
            Player.Commands playerCommands = commands;
            Object[] objectArray = new CommandButton[]{this.createSeekBackwardButton(this.customCommandSeekBackward), this.createSeekForwardButton(this.customCommandSeekForward)};
            MediaSession.ConnectionResult connectionResult2 = new MediaSession.ConnectionResult.AcceptedResultBuilder(session).setCustomLayout(CollectionsKt.listOf((Object[])objectArray)).setAvailablePlayerCommands(playerCommands).setAvailableSessionCommands(sessionCommands2).build();
            Intrinsics.checkNotNull((Object)connectionResult2);
            connectionResult = connectionResult2;
        } else if (session.isAutoCompanionController(controller)) {
            MediaSession.ConnectionResult connectionResult3 = new MediaSession.ConnectionResult.AcceptedResultBuilder(session).setAvailableSessionCommands(sessionCommands2).build();
            Intrinsics.checkNotNull((Object)connectionResult3);
            connectionResult = connectionResult3;
        } else {
            MediaSession.ConnectionResult connectionResult4 = new MediaSession.ConnectionResult.AcceptedResultBuilder(session).build();
            Intrinsics.checkNotNull((Object)connectionResult4);
            connectionResult = connectionResult4;
        }
        return connectionResult;
    }

    private final CommandButton createSeekBackwardButton(SessionCommand command) {
        CommandButton commandButton = new CommandButton.Builder().setSessionCommand(command).setDisplayName((CharSequence)"Seek Backward").setIconResId(R.drawable.baseline_arrow_back_24).build();
        Intrinsics.checkNotNullExpressionValue((Object)commandButton, (String)"build(...)");
        return commandButton;
    }

    private final CommandButton createSeekForwardButton(SessionCommand command) {
        CommandButton commandButton = new CommandButton.Builder().setSessionCommand(command).setDisplayName((CharSequence)"Seek Forward").setIconResId(R.drawable.baseline_fast_forward_24).build();
        Intrinsics.checkNotNullExpressionValue((Object)commandButton, (String)"build(...)");
        return commandButton;
    }

    /*
     * WARNING - void declaration
     */
    private final String serializeMediaItems(List<MediaItem> mediaItems) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = mediaItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaItem mediaItem = (MediaItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SerializableMediaItem.Companion.fromMediaItem((MediaItem)it));
        }
        List serializableItems = (List)destination$iv$iv;
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        iterable = $this$encodeToString$iv.getSerializersModule();
        KType kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(SerializableMediaItem.class)));
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return $this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)iterable, (KType)kType), (Object)serializableItems);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MediaItem> deserializeMediaItems(String json) {
        void $this$mapTo$iv$iv;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        Object object = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(SerializableMediaItem.class)));
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        List serializableItems = (List)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)object, (KType)kType), json);
        Iterable $this$map$iv = serializableItems;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SerializableMediaItem serializableMediaItem = (SerializableMediaItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SerializableMediaItem.Companion.toMediaItem((SerializableMediaItem)it));
        }
        return (List)destination$iv$iv;
    }

    private final MediaSession.MediaItemsWithStartPosition restorePlaylist() {
        SharedPreferences sharedPreferences = this.getSharedPreferences("PlaybackPreferences", 0);
        String mediaItemsJson = sharedPreferences.getString("savedPlaylist", null);
        long startPosition = sharedPreferences.getLong("startPosition", 0L);
        int startIndex = sharedPreferences.getInt("startIndex", 0);
        List<MediaItem> mediaItems = mediaItemsJson != null ? this.deserializeMediaItems(mediaItemsJson) : CollectionsKt.emptyList();
        return new MediaSession.MediaItemsWithStartPosition(mediaItems, startIndex, startPosition);
    }
}

