/*
 * Decompiled with CFR 0.152.
 */
package io.github.kilmajster.ngrok.control;

import io.github.kilmajster.ngrok.data.NgrokTunnel;
import io.github.kilmajster.ngrok.data.NgrokTunnelsList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"ngrok.enabled"}, havingValue="true")
@Component
public class NgrokApiClient {
    public static final String NGROK_URL_API_TUNNELS = "/api/tunnels";
    public static final String NGROK_URL_HTML_STATUS = "/status";
    private static final Logger log = LoggerFactory.getLogger(NgrokApiClient.class);
    private final String ngrokApiUrl;
    private RestTemplate restTemplate = new RestTemplate();

    public NgrokApiClient(@Value(value="${ngrok.api.url:http://localhost:4040}") String ngrokApiUrl) {
        this.ngrokApiUrl = ngrokApiUrl;
    }

    public List<NgrokTunnel> fetchTunnels() {
        try {
            NgrokTunnelsList tunnels = (NgrokTunnelsList)this.restTemplate.getForObject(this.ngrokApiUrl + NGROK_URL_API_TUNNELS, NgrokTunnelsList.class, new Object[0]);
            assert (tunnels != null);
            return tunnels.getTunnels();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isResponding() {
        String ngrokStatusUrl = this.ngrokApiUrl + NGROK_URL_HTML_STATUS;
        try {
            ResponseEntity response = this.restTemplate.getForEntity(ngrokStatusUrl, Void.class, new Object[0]);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (RestClientException restClientException) {
            return false;
        }
    }

    public String getNgrokApiUrl() {
        return this.ngrokApiUrl;
    }
}

