/*
 * Decompiled with CFR 0.152.
 */
package io.github.kilmajster.ngrok.control;

import io.github.kilmajster.ngrok.control.NgrokApiClient;
import io.github.kilmajster.ngrok.control.NgrokDownloader;
import io.github.kilmajster.ngrok.control.NgrokSystemCommandExecutor;
import io.github.kilmajster.ngrok.data.NgrokTunnel;
import io.github.kilmajster.ngrok.exception.NgrokCommandExecuteException;
import io.github.kilmajster.ngrok.exception.NgrokDownloadException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;

public class NgrokRunner {
    private static final Logger log = LoggerFactory.getLogger(NgrokRunner.class);
    private final String port;
    private final String ngrokDirectory;
    private final NgrokApiClient ngrokApiClient;
    private final NgrokDownloader ngrokDownloader;
    private final NgrokSystemCommandExecutor systemCommandExecutor;
    private final TaskExecutor ngrokExecutor;

    public NgrokRunner(@Value(value="${server.port:8080}") String port, @Value(value="${ngrok.directory:}") String ngrokDirectory, @Autowired NgrokApiClient ngrokApiClient, @Autowired NgrokDownloader ngrokDownloader, @Autowired NgrokSystemCommandExecutor systemCommandExecutor, @Autowired @Qualifier(value="ngrokExecutor") TaskExecutor ngrokExecutor) {
        this.port = port;
        this.ngrokDirectory = ngrokDirectory;
        this.ngrokApiClient = ngrokApiClient;
        this.ngrokDownloader = ngrokDownloader;
        this.systemCommandExecutor = systemCommandExecutor;
        this.ngrokExecutor = ngrokExecutor;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void run() throws NgrokDownloadException, NgrokCommandExecuteException {
        this.ngrokExecutor.execute(() -> {
            if (this.ngrokIsNotRunning()) {
                if (this.needToDownloadNgrok()) {
                    this.ngrokDownloader.downloadAndExtractNgrokTo(this.getNgrokDirectoryOrDefault());
                    this.addPermissionsIfNeeded();
                }
                this.startupNgrok();
            }
            this.logTunnelsDetails();
        });
    }

    private void addPermissionsIfNeeded() {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            String chmod = "chmod +x ".concat(this.getNgrokExecutablePath());
            log.info("Running: " + chmod);
            this.systemCommandExecutor.execute(chmod);
        }
    }

    private boolean ngrokIsNotRunning() {
        return !this.ngrokApiClient.isResponding();
    }

    private boolean needToDownloadNgrok() {
        return !Files.isExecutable(Paths.get(this.getNgrokExecutablePath(), new String[0]));
    }

    private void startupNgrok() {
        log.info("Starting ngrok...");
        String command = this.getNgrokExecutablePath() + " http " + this.port;
        this.systemCommandExecutor.execute(command);
        log.info("Ngrok is running. Dashboard url -> {}", (Object)this.ngrokApiClient.getNgrokApiUrl());
    }

    private void logTunnelsDetails() {
        List<NgrokTunnel> tunnels = this.ngrokApiClient.fetchTunnels();
        tunnels.forEach(t -> log.info("Remote url ({}) -> {}", (Object)t.getProto(), (Object)t.getPublicUrl()));
    }

    private String getNgrokExecutablePath() {
        String executable = SystemUtils.IS_OS_WINDOWS ? "ngrok.exe" : "ngrok";
        return this.getNgrokDirectoryOrDefault() + File.separator + executable;
    }

    private String getNgrokDirectoryOrDefault() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokDirectory) ? this.ngrokDirectory : this.getDefaultNgrokDirectory();
    }

    private String getDefaultNgrokDirectory() {
        return FilenameUtils.concat((String)FileUtils.getUserDirectory().getPath(), (String)".ngrok2");
    }
}

