/*
 * Decompiled with CFR 0.152.
 */
package io.github.kilmajster.ngrok.control;

import io.github.kilmajster.ngrok.exception.NgrokCommandExecuteException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"ngrok.enabled"}, havingValue="true")
@Component
public class NgrokSystemCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(NgrokSystemCommandExecutor.class);
    private final long waitForStartupMillis;

    public NgrokSystemCommandExecutor(@Value(value="${ngrok.waitForStartup.millis:3000}") long waitForStartupMillis) {
        this.waitForStartupMillis = waitForStartupMillis;
    }

    public void execute(String command) {
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(this.waitForStartupMillis);
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to run: " + command, (Throwable)e);
            throw new NgrokCommandExecuteException("Error while executing: " + command, e);
        }
    }
}

