/*
 * Decompiled with CFR 0.152.
 */
package io.github.kilmajster.ngrok.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class NgrokFileExtractUtils {
    private static final Logger log = LoggerFactory.getLogger(NgrokFileExtractUtils.class);
    private static final int BUFFER_SIZE = 4096;

    public static void extractArchive(String archiveFile, String outdirPath) {
        log.info("Extracting {} to {}", (Object)archiveFile, (Object)outdirPath);
        File archive = new File(archiveFile);
        File outdir = new File(outdirPath);
        if (StringUtils.endsWithIgnoreCase((String)archive.getName(), (String)"zip")) {
            NgrokFileExtractUtils.extractZip(archive, outdir);
            NgrokFileExtractUtils.deleteArchive(archiveFile);
        }
    }

    private static void deleteArchive(String downloadedFilePath) {
        try {
            Files.delete(Paths.get(downloadedFilePath, new String[0]));
        }
        catch (IOException e) {
            log.warn("Error while deleting {}", (Object)downloadedFilePath, (Object)e);
        }
    }

    public static void extractZip(File zipfile, File outdir) {
        try {
            ZipEntry entry;
            ZipInputStream is = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipfile)));
            while ((entry = is.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    NgrokFileExtractUtils.mkDirs(outdir, name);
                    continue;
                }
                String dir = NgrokFileExtractUtils.directoryPart(name);
                if (dir != null) {
                    NgrokFileExtractUtils.mkDirs(outdir, dir);
                }
                NgrokFileExtractUtils.extractFile(is, outdir, name);
            }
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void extractFile(InputStream inputStream, File outDir, String name) throws IOException {
        int count = -1;
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outDir, name)), 4096);
        while ((count = inputStream.read(buffer, 0, 4096)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private static void mkDirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String directoryPart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }
}

