/*
 * Decompiled with CFR 0.152.
 */
package ngrok;

import java.util.List;
import ngrok.api.NgrokApiClient;
import ngrok.api.model.NgrokTunnel;
import ngrok.configuration.NgrokConfigurationProvider;
import ngrok.exception.NgrokCommandExecuteException;
import ngrok.exception.NgrokDownloadException;
import ngrok.os.NgrokBinaryProvider;
import ngrok.os.NgrokPlatformDetector;
import ngrok.os.NgrokSystemCommandExecutor;
import ngrok.util.NgrokDownloader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;

public class NgrokRunner {
    private static final Logger log = LoggerFactory.getLogger(NgrokRunner.class);
    @Value(value="${server.port:8080}")
    private String springServerPort;
    @Value(value="${ngrok.command:}")
    private String ngrokCustomCommand;
    private final NgrokApiClient ngrokApiClient;
    private final NgrokBinaryProvider ngrokBinaryProvider;
    private final NgrokConfigurationProvider ngrokConfigurationProvider;
    private final NgrokDownloader ngrokDownloader;
    private final NgrokPlatformDetector ngrokPlatformDetector;
    private final NgrokSystemCommandExecutor ngrokSystemCommandExecutor;
    private final TaskExecutor ngrokExecutor;

    public NgrokRunner(NgrokApiClient ngrokApiClient, NgrokBinaryProvider ngrokBinaryProvider, NgrokConfigurationProvider ngrokConfigurationProvider, NgrokDownloader ngrokDownloader, NgrokPlatformDetector ngrokPlatformDetector, NgrokSystemCommandExecutor ngrokSystemCommandExecutor, TaskExecutor ngrokExecutor) {
        this.ngrokApiClient = ngrokApiClient;
        this.ngrokBinaryProvider = ngrokBinaryProvider;
        this.ngrokConfigurationProvider = ngrokConfigurationProvider;
        this.ngrokDownloader = ngrokDownloader;
        this.ngrokPlatformDetector = ngrokPlatformDetector;
        this.ngrokSystemCommandExecutor = ngrokSystemCommandExecutor;
        this.ngrokExecutor = ngrokExecutor;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void run() throws NgrokDownloadException, NgrokCommandExecuteException {
        this.ngrokExecutor.execute(() -> {
            if (this.ngrokIsNotRunning()) {
                if (this.needToDownloadNgrok()) {
                    this.downloadAndExtractNgrokBinary();
                    this.addPermissionsIfNeeded();
                }
                this.startNgrok();
            } else {
                log.info("Ngrok was already running! Dashboard url -> [ {} ]", (Object)this.ngrokApiClient.getNgrokApiUrl());
            }
            this.logTunnelsDetails();
        });
    }

    private void downloadAndExtractNgrokBinary() {
        this.ngrokDownloader.downloadAndExtractNgrokTo(this.ngrokBinaryProvider.getNgrokDirectoryOrDefault());
    }

    private void addPermissionsIfNeeded() {
        if (this.ngrokPlatformDetector.isUnix()) {
            String chmod = "chmod +x ".concat(this.ngrokBinaryProvider.getNgrokBinaryFilePath());
            log.info("Running: " + chmod);
            this.ngrokSystemCommandExecutor.execute(chmod);
        }
    }

    private boolean ngrokIsNotRunning() {
        return !this.ngrokApiClient.isResponding();
    }

    private boolean needToDownloadNgrok() {
        return !this.ngrokBinaryProvider.isNgrokBinaryPresent();
    }

    private void startNgrok() {
        String command = this.isCustomConfigPresent() ? this.buildCustomShellCmd() : this.buildNgrokDefaultShellCmd();
        log.debug("Starting ngrok with command = [ {} ]", (Object)command);
        this.ngrokSystemCommandExecutor.execute(command);
        if (this.ngrokApiClient.isResponding()) {
            log.info("Ngrok started successfully! Dashboard url -> [ {} ]", (Object)this.ngrokApiClient.getNgrokApiUrl());
        } else {
            log.warn("Ngrok seems to not responding! Ngrok status url = [ {} ] Ngrok execution command was = [ {} ]", (Object)this.ngrokApiClient.getNgrokStatusUrl(), (Object)command);
        }
    }

    private String buildNgrokDefaultShellCmd() {
        return this.ngrokBinaryProvider.getNgrokBinaryFilePath() + " http " + this.ngrokConfigurationProvider.prepareNgrokConfigParams() + this.springServerPort;
    }

    private String buildCustomShellCmd() {
        return this.ngrokBinaryProvider.getNgrokBinaryFilePath() + " " + this.ngrokCustomCommand;
    }

    private boolean isCustomConfigPresent() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokCustomCommand);
    }

    private void logTunnelsDetails() {
        List<NgrokTunnel> tunnels = this.ngrokApiClient.fetchTunnels();
        tunnels.forEach(t -> log.info("Remote url ({})\t-> [ {} ]", (Object)t.getProto(), (Object)t.getPublicUrl()));
    }
}

