/*
 * Decompiled with CFR 0.152.
 */
package ngrok.api;

import java.util.Collections;
import java.util.List;
import ngrok.NgrokComponent;
import ngrok.api.model.NgrokTunnel;
import ngrok.api.model.NgrokTunnelsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@NgrokComponent
public class NgrokApiClient {
    public static final String NGROK_URL_API_TUNNELS = "/api/tunnels";
    public static final String NGROK_URL_HTML_STATUS = "/status";
    private static final Logger log = LoggerFactory.getLogger(NgrokApiClient.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final String ngrokApiUrl;

    public NgrokApiClient(@Value(value="${ngrok.host:http://127.0.0.1}") String ngrokApiHost, @Value(value="${ngrok.port:4040}") Integer ngrokApiPort) {
        this.ngrokApiUrl = ngrokApiHost + ":" + ngrokApiPort;
    }

    public List<NgrokTunnel> fetchTunnels() {
        try {
            NgrokTunnelsList tunnels = (NgrokTunnelsList)this.restTemplate.getForObject(this.ngrokApiUrl + NGROK_URL_API_TUNNELS, NgrokTunnelsList.class, new Object[0]);
            assert (tunnels != null);
            return tunnels.getTunnels();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isResponding() {
        try {
            ResponseEntity response = this.restTemplate.getForEntity(this.getNgrokStatusUrl(), Void.class, new Object[0]);
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (RestClientException ex) {
            log.debug("Ngrok API not responding at {}", (Object)this.getNgrokStatusUrl());
            return false;
        }
    }

    public String getNgrokApiUrl() {
        return this.ngrokApiUrl;
    }

    public String getNgrokStatusUrl() {
        return this.ngrokApiUrl + NGROK_URL_HTML_STATUS;
    }
}

