/*
 * Decompiled with CFR 0.152.
 */
package ngrok.os;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import ngrok.NgrokComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.beans.factory.annotation.Value;

@NgrokComponent
public class NgrokBinaryProvider {
    @Value(value="${ngrok.directory:}")
    private String ngrokDirectory;

    public String getNgrokBinaryFilePath() {
        String executable = SystemUtils.IS_OS_WINDOWS ? "ngrok.exe" : "ngrok";
        return this.getNgrokDirectoryOrDefault() + File.separator + executable;
    }

    public String getNgrokDirectoryOrDefault() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokDirectory) ? this.ngrokDirectory : this.getDefaultNgrokDirectory();
    }

    public boolean isNgrokBinaryPresent() {
        return Files.isExecutable(Paths.get(this.getNgrokBinaryFilePath(), new String[0]));
    }

    private String getDefaultNgrokDirectory() {
        return FilenameUtils.concat((String)FileUtils.getUserDirectory().getPath(), (String)".ngrok2");
    }
}

