/*
 * Decompiled with CFR 0.152.
 */
package ngrok.os;

import java.io.IOException;
import ngrok.NgrokComponent;
import ngrok.exception.NgrokCommandExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@NgrokComponent
public class NgrokSystemCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(NgrokSystemCommandExecutor.class);
    @Value(value="${ngrok.waitForStartup.millis:3000}")
    private long waitForStartupMillis;

    public void execute(String command) {
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(this.waitForStartupMillis);
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to run: " + command, (Throwable)e);
            throw new NgrokCommandExecuteException("Error while executing: " + command, e);
        }
    }
}

