/*
 * Decompiled with CFR 0.152.
 */
package ngrok.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import ngrok.NgrokComponent;
import ngrok.exception.NgrokDownloadException;
import ngrok.os.NgrokPlatformDetector;
import ngrok.util.NgrokFileExtractUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@NgrokComponent
public class NgrokDownloader {
    private static final Logger log = LoggerFactory.getLogger(NgrokDownloader.class);
    @Value(value="${ngrok.binary.windows32:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-windows-386.zip}")
    private String windowsBinaryUrl;
    @Value(value="${ngrok.binary.linux32:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-linux-386.zip}")
    private String linuxBinaryUrl;
    @Value(value="${ngrok.binary.osx32:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-darwin-386.zip}")
    private String osxBinaryUrl;
    @Value(value="${ngrok.binary.windows:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-windows-amd64.zip}")
    private String windows64BinaryUrl;
    @Value(value="${ngrok.binary.linux:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-linux-amd64.zip}")
    private String linux64BinaryUrl;
    @Value(value="${ngrok.binary.osx:https://bin.equinox.io/c/4VmDzA7iaHb/ngrok-stable-darwin-amd64.zip}")
    private String osx64BinaryUrl;
    @Value(value="${ngrok.binary.custom:}")
    private String ngrokBinaryCustom;
    @Autowired
    private final NgrokPlatformDetector platformDetector;

    public NgrokDownloader(NgrokPlatformDetector platformDetector) {
        this.platformDetector = platformDetector;
    }

    public void downloadAndExtractNgrokTo(String destinationPath) throws NgrokDownloadException {
        String downloadedFilePath = this.downloadNgrokTo(destinationPath);
        NgrokFileExtractUtils.extractArchive(downloadedFilePath, destinationPath);
    }

    private String downloadNgrokTo(String destinationPath) throws NgrokDownloadException {
        String zipFileName = this.getFileNameFromUrl(this.getBinaryUrl());
        String destinationFile = FilenameUtils.concat((String)destinationPath, (String)zipFileName);
        if (Files.exists(Paths.get(destinationFile, new String[0]), new LinkOption[0])) {
            log.info("Skipping downloading, cached archive available at {}", (Object)destinationFile);
            return destinationFile;
        }
        log.info("Downloading ngrok from {} to {}", (Object)this.getBinaryUrl(), (Object)destinationFile);
        File targetFile = new File(destinationFile);
        long downloadStartTime = System.currentTimeMillis();
        try {
            FileUtils.copyURLToFile((URL)new URL(this.getBinaryUrl()), (File)targetFile);
            long downloadFinishTime = System.currentTimeMillis();
            log.info("Downloaded {} kb in {} ms. It will be cached in {} for the next usage.", new Object[]{FileUtils.sizeOf((File)targetFile) / 1024L, downloadFinishTime - downloadStartTime, destinationPath});
            return destinationFile;
        }
        catch (IOException e) {
            log.warn("Failed to download ngrok from {}.", (Object)this.getBinaryUrl());
            throw new NgrokDownloadException(e);
        }
    }

    private String getFileNameFromUrl(String url) {
        return url.substring(this.getBinaryUrl().lastIndexOf("/") + 1);
    }

    public String getBinaryUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.ngrokBinaryCustom)) {
            return this.ngrokBinaryCustom;
        }
        if (this.platformDetector.isWindows()) {
            return this.platformDetector.is64bitOS() ? this.windows64BinaryUrl : this.windowsBinaryUrl;
        }
        if (this.platformDetector.isMacOS()) {
            return this.platformDetector.is64bitOS() ? this.osx64BinaryUrl : this.osxBinaryUrl;
        }
        if (this.platformDetector.isLinux()) {
            return this.platformDetector.is64bitOS() ? this.linux64BinaryUrl : this.linuxBinaryUrl;
        }
        throw new NgrokDownloadException("Unsupported OS ");
    }
}

