/*
 * Decompiled with CFR 0.152.
 */
package ngrok;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ngrok.NgrokInitializedEvent;
import ngrok.api.NgrokAgentApiClient;
import ngrok.api.model.NgrokTunnel;
import ngrok.configuration.NgrokConfiguration;
import ngrok.configuration.NgrokConfigurationProvider;
import ngrok.download.NgrokDownloader;
import ngrok.exception.NgrokCommandExecuteException;
import ngrok.exception.NgrokDownloadException;
import ngrok.os.NgrokBinaryProvider;
import ngrok.os.NgrokPlatformDetector;
import ngrok.os.NgrokSystemCommandExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;

public class NgrokRunner {
    private static final Logger log = LoggerFactory.getLogger(NgrokRunner.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final NgrokConfiguration ngrokConfiguration;
    private final NgrokAgentApiClient ngrokAgentApiClient;
    private final NgrokBinaryProvider ngrokBinaryProvider;
    private final NgrokConfigurationProvider ngrokConfigurationProvider;
    private final NgrokDownloader ngrokDownloader;
    private final NgrokPlatformDetector ngrokPlatformDetector;
    private final NgrokSystemCommandExecutor ngrokSystemCommandExecutor;
    private final TaskExecutor ngrokExecutor;
    private final String applicationName;

    @EventListener
    public void run(WebServerInitializedEvent event) throws NgrokDownloadException, NgrokCommandExecuteException {
        this.ngrokExecutor.execute(() -> {
            List<NgrokTunnel> tunnels;
            int port = event.getWebServer().getPort();
            if (this.ngrokIsNotRunning()) {
                if (this.needToDownloadNgrok()) {
                    this.downloadAndExtractNgrokBinary();
                    this.addPermissionsIfNeeded();
                }
                this.configureAuthTokenOrLogWarn();
                this.startNgrok(port);
                tunnels = this.ngrokAgentApiClient.listTunnels(port);
            } else if (this.ngrokIsListening(port)) {
                log.info("Ngrok was already running! Dashboard url -> [ {} ]", (Object)this.ngrokAgentApiClient.getNgrokApiUrl());
                tunnels = this.ngrokAgentApiClient.listTunnels(port);
            } else {
                NgrokTunnel httpTunnel;
                NgrokTunnel httpsTunnel = this.ngrokAgentApiClient.startTunnel(port, "http", this.applicationName + "-http-" + port);
                if (Objects.nonNull(httpsTunnel)) {
                    log.info("New Ngrok tunnel added -> [ {}: {} ]", (Object)httpsTunnel.getName(), (Object)httpsTunnel.getPublicUrl());
                }
                if (Objects.nonNull(httpTunnel = this.ngrokAgentApiClient.tunnelDetail(this.applicationName + "-http-" + port + " (http)"))) {
                    log.info("New Ngrok tunnel added -> [ {}: {} ]", (Object)httpTunnel.getName(), (Object)httpTunnel.getPublicUrl());
                }
                tunnels = NgrokRunner.listOf(httpTunnel, httpsTunnel);
            }
            NgrokRunner.logTunnelsDetails(tunnels);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new NgrokInitializedEvent(this, tunnels));
        });
    }

    private void configureAuthTokenOrLogWarn() {
        String ngrokDirectory = this.ngrokBinaryProvider.getNgrokDirectoryOrDefault();
        if (!this.ngrokConfigurationProvider.isAuthTokenConfigured(ngrokDirectory)) {
            if (!this.ngrokConfigurationProvider.isAuthTokenPresent(ngrokDirectory)) {
                log.warn("Ngrok auth token is missing! For your personal auth token visit https://dashboard.ngrok.com/get-started/your-authtoken and then add it as ngrok.authToken=<YOUR AUTH TOKEN> to application.properties or to your ngrok configuration file.");
            } else {
                this.configureAuthToken();
            }
        }
    }

    private void configureAuthToken() {
        String command = this.ngrokBinaryProvider.getNgrokBinaryFilePath() + " authtoken " + this.ngrokConfiguration.getAuthToken();
        this.ngrokSystemCommandExecutor.execute(command);
    }

    @SafeVarargs
    private static <T> List<T> listOf(T ... args) {
        return Stream.of(args).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void downloadAndExtractNgrokBinary() {
        this.ngrokDownloader.downloadAndExtractNgrokTo(this.ngrokBinaryProvider.getNgrokDirectoryOrDefault());
    }

    private void addPermissionsIfNeeded() {
        if (this.ngrokPlatformDetector.isUnix()) {
            String chmod = "chmod +x ".concat(this.ngrokBinaryProvider.getNgrokBinaryFilePath());
            log.info("Running: " + chmod);
            this.ngrokSystemCommandExecutor.execute(chmod);
        }
    }

    private boolean ngrokIsNotRunning() {
        return !this.ngrokAgentApiClient.isResponding();
    }

    private boolean ngrokIsListening(int port) {
        return !this.ngrokAgentApiClient.listTunnels(port).isEmpty();
    }

    private boolean needToDownloadNgrok() {
        return !this.ngrokBinaryProvider.isNgrokBinaryPresent();
    }

    private void startNgrok(int springServerPort) {
        String command = this.isCustomConfigPresent() ? this.buildCustomShellCmd() : this.buildNgrokDefaultShellCmd(springServerPort);
        log.debug("Starting ngrok with command = [ {} ]", (Object)command);
        this.ngrokSystemCommandExecutor.execute(command);
        if (this.ngrokAgentApiClient.isResponding()) {
            log.info("Ngrok started successfully! Dashboard url -> [ {} ]", (Object)this.ngrokAgentApiClient.getNgrokApiUrl());
        } else {
            log.warn("Ngrok seems to not responding! Ngrok status url = [ {} ] Ngrok execution command was = [ {} ]", (Object)this.ngrokAgentApiClient.getNgrokStatusUrl(), (Object)command);
        }
    }

    private String buildNgrokDefaultShellCmd(int springServerPort) {
        return this.ngrokBinaryProvider.getNgrokBinaryFilePath() + " http " + this.ngrokConfigurationProvider.prepareNgrokConfigParams() + springServerPort;
    }

    private String buildCustomShellCmd() {
        return this.ngrokBinaryProvider.getNgrokBinaryFilePath() + " " + this.ngrokConfiguration.getCommand();
    }

    private boolean isCustomConfigPresent() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokConfiguration.getCommand());
    }

    private static void logTunnelsDetails(List<NgrokTunnel> tunnels) {
        tunnels.forEach(t -> log.info("Remote url ({})\t-> [ {} ]", (Object)t.getProto(), (Object)t.getPublicUrl()));
    }

    public NgrokRunner(ApplicationEventPublisher applicationEventPublisher, NgrokConfiguration ngrokConfiguration, NgrokAgentApiClient ngrokAgentApiClient, NgrokBinaryProvider ngrokBinaryProvider, NgrokConfigurationProvider ngrokConfigurationProvider, NgrokDownloader ngrokDownloader, NgrokPlatformDetector ngrokPlatformDetector, NgrokSystemCommandExecutor ngrokSystemCommandExecutor, TaskExecutor ngrokExecutor, String applicationName) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.ngrokConfiguration = ngrokConfiguration;
        this.ngrokAgentApiClient = ngrokAgentApiClient;
        this.ngrokBinaryProvider = ngrokBinaryProvider;
        this.ngrokConfigurationProvider = ngrokConfigurationProvider;
        this.ngrokDownloader = ngrokDownloader;
        this.ngrokPlatformDetector = ngrokPlatformDetector;
        this.ngrokSystemCommandExecutor = ngrokSystemCommandExecutor;
        this.ngrokExecutor = ngrokExecutor;
        this.applicationName = applicationName;
    }
}

