/*
 * Decompiled with CFR 0.152.
 */
package ngrok.api;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ngrok.NgrokComponent;
import ngrok.api.model.NgrokCapturedRequest;
import ngrok.api.model.NgrokCapturedRequestsList;
import ngrok.api.model.NgrokTunnel;
import ngrok.api.model.NgrokTunnelsList;
import ngrok.api.rquest.NgrokReplayCapturedRequest;
import ngrok.api.rquest.NgrokStartTunnel;
import ngrok.configuration.NgrokConfiguration;
import ngrok.exception.NgrokApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@NgrokComponent
public class NgrokAgentApiClient {
    private static final Logger log = LoggerFactory.getLogger(NgrokAgentApiClient.class);
    private final RestTemplate restTemplate = new RestTemplate();
    public static final String URI_NGROK_API_TUNNELS = "/api/tunnels";
    public static final String URI_NGROK_API_TUNNEL_DETAIL = "/api/tunnels/{tunnelName}";
    public static final String URI_NGROK_API_CAPTURED_REQUESTS = "/api/requests/http";
    public static final String URI_NGROK_API_CAPTURED_REQUEST_DETAILS = "/api/requests/http/{requestId}";
    public static final String URI_NGROK_HTML_STATUS = "/status";
    private final String ngrokApiUrl;

    public NgrokAgentApiClient(NgrokConfiguration ngrokConfiguration) {
        this.ngrokApiUrl = ngrokConfiguration.getHost() + ":" + ngrokConfiguration.getPort();
    }

    public List<NgrokTunnel> listTunnels() {
        try {
            return ((NgrokTunnelsList)this.restTemplate.getForObject(this.apiUrlOf(URI_NGROK_API_TUNNELS), NgrokTunnelsList.class, new Object[0])).getTunnels();
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public List<NgrokTunnel> listTunnels(int port) {
        return this.listTunnels().stream().filter(it -> it.getConfig().getAddr().endsWith(String.valueOf(port))).collect(Collectors.toList());
    }

    private String apiUrlOf(String apiUri) {
        return this.ngrokApiUrl + apiUri;
    }

    public NgrokTunnel startTunnel(int addr, String proto, String name) {
        try {
            ResponseEntity startTunnelResponse = this.restTemplate.postForEntity(this.apiUrlOf(URI_NGROK_API_TUNNELS), (Object)NgrokStartTunnel.of(addr, proto, name), NgrokTunnel.class, new Object[0]);
            if (startTunnelResponse.getStatusCodeValue() != 201) {
                log.warn("Failed to start ngrok tunnel!");
            }
            return (NgrokTunnel)startTunnelResponse.getBody();
        }
        catch (Exception ex) {
            throw new NgrokApiException("Failed to start ngrok tunnel!", ex);
        }
    }

    public NgrokTunnel tunnelDetail(String tunnelName) {
        try {
            return (NgrokTunnel)this.restTemplate.getForObject(this.apiUrlOf(URI_NGROK_API_TUNNEL_DETAIL), NgrokTunnel.class, new Object[]{tunnelName});
        }
        catch (Exception ex) {
            throw new NgrokApiException("Failed to fetch details of ngrok tunnel with tunnelName = " + tunnelName, ex);
        }
    }

    public boolean stopTunnel(String tunnelName) {
        try {
            return this.restTemplate.exchange(this.apiUrlOf(URI_NGROK_API_TUNNEL_DETAIL), HttpMethod.DELETE, null, Void.class, new Object[]{tunnelName}).getStatusCodeValue() == 204;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<NgrokCapturedRequest> listCapturedRequests(Integer limit, String tunnelName) {
        try {
            return ((NgrokCapturedRequestsList)this.restTemplate.getForObject(UriComponentsBuilder.fromUriString((String)this.apiUrlOf(URI_NGROK_API_CAPTURED_REQUESTS)).queryParamIfPresent("limit", Optional.ofNullable(limit)).queryParamIfPresent("tunnel_name", Optional.ofNullable(tunnelName)).toUriString(), NgrokCapturedRequestsList.class, new Object[0])).getRequests();
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    public List<NgrokCapturedRequest> listCapturedRequests(Integer limit) {
        return this.listCapturedRequests(limit, null);
    }

    public List<NgrokCapturedRequest> listCapturedRequests(String tunnelName) {
        return this.listCapturedRequests(null, tunnelName);
    }

    public List<NgrokCapturedRequest> listCapturedRequests() {
        return this.listCapturedRequests(null, null);
    }

    public boolean replayCapturedRequest(String id, String tunnelName) {
        try {
            return this.restTemplate.postForEntity(this.apiUrlOf(URI_NGROK_API_CAPTURED_REQUESTS), (Object)NgrokReplayCapturedRequest.of(id, tunnelName), Void.class, new Object[0]).getStatusCodeValue() == 204;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean deleteCapturedRequests() {
        try {
            return this.restTemplate.exchange(this.apiUrlOf(URI_NGROK_API_CAPTURED_REQUESTS), HttpMethod.DELETE, null, Void.class, new Object[0]).getStatusCodeValue() == 204;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public NgrokCapturedRequest capturedRequestDetail(String requestId) {
        try {
            return (NgrokCapturedRequest)this.restTemplate.getForObject(this.apiUrlOf(URI_NGROK_API_CAPTURED_REQUEST_DETAILS), NgrokCapturedRequest.class, new Object[]{requestId});
        }
        catch (Exception ex) {
            throw new NgrokApiException("Failed to fetch details of ngrok request with requestId = " + requestId, ex);
        }
    }

    public boolean isResponding() {
        try {
            return this.restTemplate.getForEntity(this.getNgrokStatusUrl(), Void.class, new Object[0]).getStatusCodeValue() == 200;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getNgrokStatusUrl() {
        return this.ngrokApiUrl + URI_NGROK_HTML_STATUS;
    }

    public String getHttpTunnelUrl() {
        return this.listTunnels().stream().filter(NgrokTunnel::isHttp).findFirst().map(NgrokTunnel::getPublicUrl).orElse(null);
    }

    public String getHttpsTunnelUrl() {
        return this.listTunnels().stream().filter(NgrokTunnel::isHttps).findFirst().map(NgrokTunnel::getPublicUrl).orElse(null);
    }

    @Deprecated
    public boolean isRunning() {
        return this.isResponding();
    }

    public String getNgrokApiUrl() {
        return this.ngrokApiUrl;
    }
}

