/*
 * Decompiled with CFR 0.152.
 */
package ngrok.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NgrokCapturedRequest
implements Serializable {
    private String uri;
    private String id;
    @JsonProperty(value="tunnel_name")
    private String tunnelName;
    @JsonProperty(value="remote_addr")
    private String remoteAddr;
    private Date start;
    private int duration;
    private NgrokRequest request;
    private NgrokResponse response;

    public NgrokCapturedRequest() {
    }

    NgrokCapturedRequest(String uri, String id, String tunnelName, String remoteAddr, Date start, int duration, NgrokRequest request, NgrokResponse response) {
        this.uri = uri;
        this.id = id;
        this.tunnelName = tunnelName;
        this.remoteAddr = remoteAddr;
        this.start = start;
        this.duration = duration;
        this.request = request;
        this.response = response;
    }

    public static NgrokCapturedRequestBuilder builder() {
        return new NgrokCapturedRequestBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public String getTunnelName() {
        return this.tunnelName;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Date getStart() {
        return this.start;
    }

    public int getDuration() {
        return this.duration;
    }

    public NgrokRequest getRequest() {
        return this.request;
    }

    public NgrokResponse getResponse() {
        return this.response;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tunnel_name")
    public void setTunnelName(String tunnelName) {
        this.tunnelName = tunnelName;
    }

    @JsonProperty(value="remote_addr")
    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setRequest(NgrokRequest request) {
        this.request = request;
    }

    public void setResponse(NgrokResponse response) {
        this.response = response;
    }

    public static class NgrokCapturedRequestBuilder {
        private String uri;
        private String id;
        private String tunnelName;
        private String remoteAddr;
        private Date start;
        private int duration;
        private NgrokRequest request;
        private NgrokResponse response;

        NgrokCapturedRequestBuilder() {
        }

        public NgrokCapturedRequestBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public NgrokCapturedRequestBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tunnel_name")
        public NgrokCapturedRequestBuilder tunnelName(String tunnelName) {
            this.tunnelName = tunnelName;
            return this;
        }

        @JsonProperty(value="remote_addr")
        public NgrokCapturedRequestBuilder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public NgrokCapturedRequestBuilder start(Date start) {
            this.start = start;
            return this;
        }

        public NgrokCapturedRequestBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public NgrokCapturedRequestBuilder request(NgrokRequest request) {
            this.request = request;
            return this;
        }

        public NgrokCapturedRequestBuilder response(NgrokResponse response) {
            this.response = response;
            return this;
        }

        public NgrokCapturedRequest build() {
            return new NgrokCapturedRequest(this.uri, this.id, this.tunnelName, this.remoteAddr, this.start, this.duration, this.request, this.response);
        }

        public String toString() {
            return "NgrokCapturedRequest.NgrokCapturedRequestBuilder(uri=" + this.uri + ", id=" + this.id + ", tunnelName=" + this.tunnelName + ", remoteAddr=" + this.remoteAddr + ", start=" + this.start + ", duration=" + this.duration + ", request=" + this.request + ", response=" + this.response + ")";
        }
    }

    public static class NgrokHeaders {
        private Map<String, List<String>> headers;

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }
    }

    public static class NgrokResponse {
        private String status;
        @JsonProperty(value="status_code")
        private int statusCode;
        private String proto;
        @JsonUnwrapped
        private NgrokHeaders headers;
        private String raw;

        public String getStatus() {
            return this.status;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getProto() {
            return this.proto;
        }

        public NgrokHeaders getHeaders() {
            return this.headers;
        }

        public String getRaw() {
            return this.raw;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="status_code")
        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public void setProto(String proto) {
            this.proto = proto;
        }

        @JsonUnwrapped
        public void setHeaders(NgrokHeaders headers) {
            this.headers = headers;
        }

        public void setRaw(String raw) {
            this.raw = raw;
        }
    }

    public static class NgrokRequest {
        @JsonSerialize
        private String method;
        private String proto;
        @JsonUnwrapped
        private NgrokHeaders headers;
        private String uri;
        private String raw;

        public String getMethod() {
            return this.method;
        }

        public String getProto() {
            return this.proto;
        }

        public NgrokHeaders getHeaders() {
            return this.headers;
        }

        public String getUri() {
            return this.uri;
        }

        public String getRaw() {
            return this.raw;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setProto(String proto) {
            this.proto = proto;
        }

        @JsonUnwrapped
        public void setHeaders(NgrokHeaders headers) {
            this.headers = headers;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setRaw(String raw) {
            this.raw = raw;
        }
    }
}

