/*
 * Decompiled with CFR 0.152.
 */
package ngrok.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NgrokTunnel
implements Serializable {
    private String name;
    private String uri;
    @JsonProperty(value="public_url")
    private String publicUrl;
    private String proto;
    private NgrokTunnelConfig config;
    private NgrokTunnelMetrics metrics;

    public NgrokTunnel() {
    }

    @JsonIgnore
    public boolean isHttps() {
        return "https".equals(this.proto);
    }

    @JsonIgnore
    public boolean isHttp() {
        return "http".equals(this.proto);
    }

    NgrokTunnel(String name, String uri, String publicUrl, String proto, NgrokTunnelConfig config, NgrokTunnelMetrics metrics) {
        this.name = name;
        this.uri = uri;
        this.publicUrl = publicUrl;
        this.proto = proto;
        this.config = config;
        this.metrics = metrics;
    }

    public static NgrokTunnelBuilder builder() {
        return new NgrokTunnelBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public String getProto() {
        return this.proto;
    }

    public NgrokTunnelConfig getConfig() {
        return this.config;
    }

    public NgrokTunnelMetrics getMetrics() {
        return this.metrics;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @JsonProperty(value="public_url")
    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public void setProto(String proto) {
        this.proto = proto;
    }

    public void setConfig(NgrokTunnelConfig config) {
        this.config = config;
    }

    public void setMetrics(NgrokTunnelMetrics metrics) {
        this.metrics = metrics;
    }

    public static class NgrokTunnelBuilder {
        private String name;
        private String uri;
        private String publicUrl;
        private String proto;
        private NgrokTunnelConfig config;
        private NgrokTunnelMetrics metrics;

        NgrokTunnelBuilder() {
        }

        public NgrokTunnelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NgrokTunnelBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @JsonProperty(value="public_url")
        public NgrokTunnelBuilder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            return this;
        }

        public NgrokTunnelBuilder proto(String proto) {
            this.proto = proto;
            return this;
        }

        public NgrokTunnelBuilder config(NgrokTunnelConfig config) {
            this.config = config;
            return this;
        }

        public NgrokTunnelBuilder metrics(NgrokTunnelMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public NgrokTunnel build() {
            return new NgrokTunnel(this.name, this.uri, this.publicUrl, this.proto, this.config, this.metrics);
        }

        public String toString() {
            return "NgrokTunnel.NgrokTunnelBuilder(name=" + this.name + ", uri=" + this.uri + ", publicUrl=" + this.publicUrl + ", proto=" + this.proto + ", config=" + this.config + ", metrics=" + this.metrics + ")";
        }
    }

    public static class NgrokTunnelMetrics {
        private Map<String, Double> conns;
        private Map<String, Double> http;

        public NgrokTunnelMetrics() {
        }

        NgrokTunnelMetrics(Map<String, Double> conns, Map<String, Double> http) {
            this.conns = conns;
            this.http = http;
        }

        public static NgrokTunnelMetricsBuilder builder() {
            return new NgrokTunnelMetricsBuilder();
        }

        public Map<String, Double> getConns() {
            return this.conns;
        }

        public Map<String, Double> getHttp() {
            return this.http;
        }

        public void setConns(Map<String, Double> conns) {
            this.conns = conns;
        }

        public void setHttp(Map<String, Double> http) {
            this.http = http;
        }

        public static class NgrokTunnelMetricsBuilder {
            private Map<String, Double> conns;
            private Map<String, Double> http;

            NgrokTunnelMetricsBuilder() {
            }

            public NgrokTunnelMetricsBuilder conns(Map<String, Double> conns) {
                this.conns = conns;
                return this;
            }

            public NgrokTunnelMetricsBuilder http(Map<String, Double> http) {
                this.http = http;
                return this;
            }

            public NgrokTunnelMetrics build() {
                return new NgrokTunnelMetrics(this.conns, this.http);
            }

            public String toString() {
                return "NgrokTunnel.NgrokTunnelMetrics.NgrokTunnelMetricsBuilder(conns=" + this.conns + ", http=" + this.http + ")";
            }
        }
    }

    public static class NgrokTunnelConfig {
        private String addr;
        private boolean inspect;

        public NgrokTunnelConfig() {
        }

        NgrokTunnelConfig(String addr, boolean inspect) {
            this.addr = addr;
            this.inspect = inspect;
        }

        public static NgrokTunnelConfigBuilder builder() {
            return new NgrokTunnelConfigBuilder();
        }

        public String getAddr() {
            return this.addr;
        }

        public boolean isInspect() {
            return this.inspect;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        public void setInspect(boolean inspect) {
            this.inspect = inspect;
        }

        public static class NgrokTunnelConfigBuilder {
            private String addr;
            private boolean inspect;

            NgrokTunnelConfigBuilder() {
            }

            public NgrokTunnelConfigBuilder addr(String addr) {
                this.addr = addr;
                return this;
            }

            public NgrokTunnelConfigBuilder inspect(boolean inspect) {
                this.inspect = inspect;
                return this;
            }

            public NgrokTunnelConfig build() {
                return new NgrokTunnelConfig(this.addr, this.inspect);
            }

            public String toString() {
                return "NgrokTunnel.NgrokTunnelConfig.NgrokTunnelConfigBuilder(addr=" + this.addr + ", inspect=" + this.inspect + ")";
            }
        }
    }
}

