/*
 * Decompiled with CFR 0.152.
 */
package ngrok.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class NgrokAuthTokenUtil {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static Optional<String> getAuthToken(String ngrokYamlConfigPath, String ngrokDirectory) {
        String authToken;
        String defaultNgrokConfigFilePath = ngrokDirectory + File.separator + "ngrok.yml";
        boolean defaultConfigFileExist = Files.exists(Paths.get(defaultNgrokConfigFilePath, new String[0]), new LinkOption[0]);
        if (defaultConfigFileExist && Objects.nonNull(authToken = NgrokAuthTokenUtil.readNgrokConfig(defaultNgrokConfigFilePath).getAuthToken())) {
            return Optional.of(authToken);
        }
        try {
            return Stream.of(StringUtils.split((String)ngrokYamlConfigPath, (String)";")).map(path -> NgrokAuthTokenUtil.readNgrokConfig(path).getAuthToken()).findAny();
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private static NgrokYamlConfigModel readNgrokConfig(String path) {
        return (NgrokYamlConfigModel)mapper.readValue(new File(path), NgrokYamlConfigModel.class);
    }

    private static class NgrokYamlConfigModel {
        @JsonAlias(value={"authtoken"})
        private String authToken;

        public String getAuthToken() {
            return this.authToken;
        }

        @JsonAlias(value={"authtoken"})
        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NgrokYamlConfigModel)) {
                return false;
            }
            NgrokYamlConfigModel other = (NgrokYamlConfigModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$authToken = this.getAuthToken();
            String other$authToken = other.getAuthToken();
            return !(this$authToken == null ? other$authToken != null : !this$authToken.equals(other$authToken));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NgrokYamlConfigModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $authToken = this.getAuthToken();
            result = result * 59 + ($authToken == null ? 43 : $authToken.hashCode());
            return result;
        }

        public String toString() {
            return "NgrokAuthTokenUtil.NgrokYamlConfigModel(authToken=" + this.getAuthToken() + ")";
        }
    }
}

