/*
 * Decompiled with CFR 0.152.
 */
package ngrok.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import ngrok.NgrokComponent;
import ngrok.configuration.NgrokAuthTokenUtil;
import ngrok.configuration.NgrokConfiguration;
import ngrok.exception.NgrokMalformedConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

@NgrokComponent
public class NgrokConfigurationProvider {
    private static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private final NgrokConfiguration ngrokConfiguration;

    public String prepareNgrokConfigParams() {
        return this.isConfigPresent() ? this.loadNgrokConfigFile() : "";
    }

    public boolean isAuthTokenPresent(String ngrokDirectory) {
        return StringUtils.isNotBlank((CharSequence)this.ngrokConfiguration.getAuthToken()) || NgrokAuthTokenUtil.getAuthToken(this.ngrokConfiguration.getConfig(), ngrokDirectory).isPresent();
    }

    public boolean isAuthTokenConfigured(String ngrokDirectory) {
        return NgrokAuthTokenUtil.getAuthToken(this.ngrokConfiguration.getConfig(), ngrokDirectory).isPresent();
    }

    private String loadNgrokConfigFile() {
        return this.isClasspathConfig() ? this.handleClasspathConfig() : this.loadConfigurationFile(this.ngrokConfiguration.getConfig());
    }

    private String handleClasspathConfig() {
        try {
            String tempConfigPath = this.copyClassPathConfigToTempFile();
            return this.loadConfigurationFile(tempConfigPath);
        }
        catch (Exception e) {
            throw new NgrokMalformedConfigurationException("Error while loading ngrok classpath configuration!", e);
        }
    }

    private String copyClassPathConfigToTempFile() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(this.getClassPathConfigFilePath());
        String configContent = FileUtils.readFileToString((File)classPathResource.getFile(), (Charset)Charset.defaultCharset());
        File configTempFile = Files.createTempFile(this.extractFileName(classPathResource.getFilename()), this.extractFileExtension(classPathResource.getFilename()), new FileAttribute[0]).toFile();
        FileUtils.writeStringToFile((File)configTempFile, (String)configContent, (Charset)Charset.defaultCharset());
        return configTempFile.getAbsolutePath();
    }

    private String getClassPathConfigFilePath() {
        return StringUtils.removeStart((String)this.ngrokConfiguration.getConfig(), (String)CLASSPATH_CONFIG_PREFIX);
    }

    private String extractFileName(String fullFilename) {
        return StringUtils.split((String)fullFilename, (String)".")[0];
    }

    private String extractFileExtension(String fullFilename) {
        return ".".concat(StringUtils.split((String)fullFilename, (String)".")[1]);
    }

    private String loadConfigurationFile(String configPath) {
        return StringUtils.split((String)configPath, (String)";").length == 1 ? "-config " + configPath + " " : "-config " + String.join((CharSequence)" -config ", StringUtils.split((String)configPath, (String)";")) + " ";
    }

    private boolean isConfigPresent() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokConfiguration.getConfig());
    }

    private boolean isClasspathConfig() {
        return StringUtils.startsWith((CharSequence)this.ngrokConfiguration.getConfig(), (CharSequence)CLASSPATH_CONFIG_PREFIX);
    }

    public NgrokConfigurationProvider(NgrokConfiguration ngrokConfiguration) {
        this.ngrokConfiguration = ngrokConfiguration;
    }
}

