/*
 * Decompiled with CFR 0.152.
 */
package ngrok.download;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import ngrok.NgrokComponent;
import ngrok.configuration.NgrokConfiguration;
import ngrok.download.NgrokArchiveUrlProvider;
import ngrok.download.NgrokFileExtractUtils;
import ngrok.exception.NgrokDownloadException;
import ngrok.os.NgrokPlatformDetector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NgrokComponent
public class NgrokDownloader {
    private static final Logger log = LoggerFactory.getLogger(NgrokDownloader.class);
    private final NgrokArchiveUrlProvider ngrokArchiveUrlProvider;
    private final NgrokConfiguration ngrokConfiguration;
    private final NgrokPlatformDetector platformDetector;

    public void downloadAndExtractNgrokTo(String destinationPath) throws NgrokDownloadException {
        String downloadedFilePath = this.downloadNgrokTo(destinationPath);
        NgrokFileExtractUtils.extractArchive(downloadedFilePath, destinationPath);
    }

    private String downloadNgrokTo(String destinationPath) throws NgrokDownloadException {
        String archiveFileName = this.getFileNameFromUrl(this.getBinaryUrl());
        String destinationFile = FilenameUtils.concat((String)destinationPath, (String)archiveFileName);
        if (Files.exists(Paths.get(destinationFile, new String[0]), new LinkOption[0])) {
            log.info("Skipping downloading, cached archive available at {}", (Object)destinationFile);
            return destinationFile;
        }
        log.info("Downloading ngrok from {} to {}", (Object)this.getBinaryUrl(), (Object)destinationFile);
        File targetFile = new File(destinationFile);
        long downloadStartTime = System.currentTimeMillis();
        try {
            FileUtils.copyURLToFile((URL)new URL(this.getBinaryUrl()), (File)targetFile);
            long downloadFinishTime = System.currentTimeMillis();
            log.info("Downloaded {} kb in {} ms. It will be cached in {} for the next usage.", new Object[]{FileUtils.sizeOf((File)targetFile) / 1024L, downloadFinishTime - downloadStartTime, destinationPath});
            return destinationFile;
        }
        catch (IOException e) {
            log.warn("Failed to download ngrok from {}.", (Object)this.getBinaryUrl());
            throw new NgrokDownloadException(e);
        }
    }

    private String getFileNameFromUrl(String url) {
        return url.substring(this.getBinaryUrl().lastIndexOf("/") + 1);
    }

    private String getBinaryUrl() {
        if (StringUtils.isNotBlank((CharSequence)this.ngrokConfiguration.getCustomArchiveUrl())) {
            return this.ngrokConfiguration.getCustomArchiveUrl();
        }
        if (this.platformDetector.isWindows()) {
            return this.platformDetector.is64bitOS() ? this.ngrokArchiveUrlProvider.getWindows() : this.ngrokArchiveUrlProvider.getWindows32();
        }
        if (this.platformDetector.isMacOS()) {
            return this.platformDetector.is64bitOS() ? this.ngrokArchiveUrlProvider.getOsx() : this.ngrokArchiveUrlProvider.getOsx32();
        }
        if (this.platformDetector.isLinux()) {
            return this.platformDetector.is64bitOS() ? this.ngrokArchiveUrlProvider.getLinux() : this.ngrokArchiveUrlProvider.getLinux32();
        }
        throw new NgrokDownloadException("Unsupported OS");
    }

    public NgrokDownloader(NgrokArchiveUrlProvider ngrokArchiveUrlProvider, NgrokConfiguration ngrokConfiguration, NgrokPlatformDetector platformDetector) {
        this.ngrokArchiveUrlProvider = ngrokArchiveUrlProvider;
        this.ngrokConfiguration = ngrokConfiguration;
        this.platformDetector = platformDetector;
    }
}

