/*
 * Decompiled with CFR 0.152.
 */
package ngrok.os;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import ngrok.NgrokComponent;
import ngrok.configuration.NgrokConfiguration;
import ngrok.os.NgrokSystemCommandExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

@NgrokComponent
public class NgrokBinaryProvider {
    private final NgrokConfiguration ngrokConfiguration;
    private final NgrokSystemCommandExecutor ngrokSystemCommandExecutor;

    public String getNgrokBinaryFilePath() {
        String executable = SystemUtils.IS_OS_WINDOWS ? "ngrok.exe" : "ngrok";
        return this.ngrokSystemCommandExecutor.isPresentInPath(executable) && this.ngrokConfiguration.isUseFromPath() ? executable : this.getNgrokDirectoryOrDefault() + File.separator + executable;
    }

    public String getNgrokDirectoryOrDefault() {
        return StringUtils.isNotBlank((CharSequence)this.ngrokConfiguration.getDirectory()) ? this.ngrokConfiguration.getDirectory() : this.getDefaultNgrokDirectory();
    }

    public boolean isNgrokBinaryPresent() {
        return Files.isExecutable(Paths.get(this.getNgrokBinaryFilePath(), new String[0]));
    }

    private String getDefaultNgrokDirectory() {
        return FilenameUtils.concat((String)FileUtils.getUserDirectory().getPath(), (String)(this.ngrokConfiguration.isLegacy() ? ".ngrok2" : ".ngrok3"));
    }

    public NgrokBinaryProvider(NgrokConfiguration ngrokConfiguration, NgrokSystemCommandExecutor ngrokSystemCommandExecutor) {
        this.ngrokConfiguration = ngrokConfiguration;
        this.ngrokSystemCommandExecutor = ngrokSystemCommandExecutor;
    }
}

