/*
 * Decompiled with CFR 0.152.
 */
package ngrok.os;

import java.io.IOException;
import ngrok.NgrokComponent;
import ngrok.configuration.NgrokConfiguration;
import ngrok.exception.NgrokCommandExecuteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NgrokComponent
public class NgrokSystemCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(NgrokSystemCommandExecutor.class);
    private final NgrokConfiguration ngrokConfiguration;

    public void execute(String command) {
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(this.ngrokConfiguration.getStartupDelay());
        }
        catch (IOException | InterruptedException e) {
            log.error("Failed to run: " + command, (Throwable)e);
            throw new NgrokCommandExecuteException("Error while executing: " + command, e);
        }
    }

    public boolean isPresentInPath(String executable) {
        try {
            Runtime.getRuntime().exec(executable);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public NgrokSystemCommandExecutor(NgrokConfiguration ngrokConfiguration) {
        this.ngrokConfiguration = ngrokConfiguration;
    }
}

