/*
 * Decompiled with CFR 0.152.
 */
package mongo4cats.circe;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.UUID;
import mongo4cats.Uuid$;
import mongo4cats.bson.BsonValue;
import mongo4cats.bson.BsonValue$;
import mongo4cats.bson.Document;
import mongo4cats.bson.Document$;
import mongo4cats.bson.json;
import mongo4cats.bson.package;
import mongo4cats.circe.CirceJsonMapper$JsonNumberSyntax$;
import mongo4cats.circe.CirceJsonMapper$JsonSyntax$;
import mongo4cats.errors;
import org.bson.types.ObjectId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class CirceJsonMapper$
implements json.JsonMapper<Json> {
    public static final CirceJsonMapper$ MODULE$ = new CirceJsonMapper$();

    public BsonValue toBson(Json json3) {
        Json json4 = json3;
        if (json4.isNull()) {
            return BsonValue$.MODULE$.Null();
        }
        if (json4.isArray()) {
            return BsonValue$.MODULE$.array((Iterable)((StrictOptimizedIterableOps)json4.asArray().get()).map((Function1 & Serializable)json2 -> MODULE$.toBson((Json)json2)));
        }
        if (json4.isBoolean()) {
            return BsonValue$.MODULE$.boolean(BoxesRunTime.unboxToBoolean((Object)json4.asBoolean().get()));
        }
        if (json4.isString()) {
            return BsonValue$.MODULE$.string((String)json4.asString().get());
        }
        if (json4.isNumber()) {
            return CirceJsonMapper$JsonNumberSyntax$.MODULE$.toBsonValue$extension(this.JsonNumberSyntax((JsonNumber)json4.asNumber().get()));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isId$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.objectId(package.ObjectId$.MODULE$.apply((String)this.jsonToObjectIdString(json4).get()));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isEpochMillis$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.instant(Instant.ofEpochMilli(CirceJsonMapper$JsonSyntax$.MODULE$.asEpochMillis$extension(this.JsonSyntax(json4))));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isLocalDate$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.instant(LocalDate.parse((CharSequence)this.jsonToDateString(json4).get()).atStartOfDay().toInstant(ZoneOffset.UTC));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isDate$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.instant(Instant.parse((CharSequence)this.jsonToDateString(json4).get()));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isBinaryArray$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.binary(Base64.getDecoder().decode((String)this.jsonToBinaryBase64(json4).get()));
        }
        if (CirceJsonMapper$JsonSyntax$.MODULE$.isUuid$extension(this.JsonSyntax(json4))) {
            return BsonValue$.MODULE$.uuid(this.jsonToUuid(json3));
        }
        return BsonValue$.MODULE$.document(Document$.MODULE$.apply((Iterable)((JsonObject)json4.asObject().get()).toList().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Json value = (Json)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.toBson(value));
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    private final Json JsonSyntax(Json json2) {
        return json2;
    }

    private final JsonNumber JsonNumberSyntax(JsonNumber jNumber) {
        return jNumber;
    }

    public Either<errors.MongoJsonParsingException, Json> fromBson(BsonValue bson2) {
        BsonValue bsonValue = bson2;
        if (BsonValue.BNull$.MODULE$.equals(bsonValue)) {
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.Null());
        }
        if (bsonValue instanceof BsonValue.BObjectId) {
            BsonValue.BObjectId bObjectId = (BsonValue.BObjectId)bsonValue;
            ObjectId value = bObjectId.value();
            return package$.MODULE$.Right().apply((Object)this.objectIdToJson(value));
        }
        if (bsonValue instanceof BsonValue.BDateTime) {
            BsonValue.BDateTime bDateTime = (BsonValue.BDateTime)bsonValue;
            Instant value = bDateTime.value();
            return package$.MODULE$.Right().apply((Object)this.instantToJson(value));
        }
        if (bsonValue instanceof BsonValue.BInt32) {
            BsonValue.BInt32 bInt32 = (BsonValue.BInt32)bsonValue;
            int value = bInt32.value();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromInt(value));
        }
        if (bsonValue instanceof BsonValue.BInt64) {
            BsonValue.BInt64 bInt64 = (BsonValue.BInt64)bsonValue;
            long value = bInt64.value();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromLong(value));
        }
        if (bsonValue instanceof BsonValue.BBoolean) {
            BsonValue.BBoolean bBoolean = (BsonValue.BBoolean)bsonValue;
            boolean value = bBoolean.value();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromBoolean(value));
        }
        if (bsonValue instanceof BsonValue.BDecimal) {
            BsonValue.BDecimal bDecimal = (BsonValue.BDecimal)bsonValue;
            BigDecimal value = bDecimal.value();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromBigDecimal(value));
        }
        if (bsonValue instanceof BsonValue.BString) {
            BsonValue.BString bString = (BsonValue.BString)bsonValue;
            String value = bString.value();
            return package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromString(value));
        }
        if (bsonValue instanceof BsonValue.BDouble) {
            BsonValue.BDouble bDouble = (BsonValue.BDouble)bsonValue;
            double value = bDouble.value();
            return Json$.MODULE$.fromDouble(value).toRight((Function0 & Serializable)() -> new errors.MongoJsonParsingException(new StringBuilder(22).append(value).append(" is not a valid double").toString(), errors.MongoJsonParsingException$.MODULE$.apply$default$2()));
        }
        if (bsonValue instanceof BsonValue.BArray) {
            BsonValue.BArray bArray = (BsonValue.BArray)bsonValue;
            Iterable value = bArray.value();
            return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)value.toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)bson -> MODULE$.fromBson((BsonValue)bson), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)values -> Json$.MODULE$.fromValues(values));
        }
        if (bsonValue instanceof BsonValue.BBinary) {
            BsonValue.BBinary bBinary = (BsonValue.BBinary)bsonValue;
            byte[] value = bBinary.value();
            return package$.MODULE$.Right().apply((Object)this.binaryArrayToJson(value));
        }
        if (bsonValue instanceof BsonValue.BUuid) {
            BsonValue.BUuid bUuid = (BsonValue.BUuid)bsonValue;
            UUID value = bUuid.value();
            return package$.MODULE$.Right().apply((Object)this.uuidToJson(value));
        }
        if (bsonValue instanceof BsonValue.BDocument) {
            BsonValue.BDocument bDocument = (BsonValue.BDocument)bsonValue;
            Document value = bDocument.value();
            return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)value.toList().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CirceJsonMapper$.$anonfun$fromBson$4(x0$1))), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    BsonValue v = (BsonValue)tuple2._2();
                    return MODULE$.fromBson(v).map((Function1 & Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), x$13));
                }
                throw new MatchError((Object)tuple2);
            }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)fields -> Json$.MODULE$.fromFields(fields));
        }
        return package$.MODULE$.Left().apply((Object)new errors.MongoJsonParsingException(new StringBuilder(30).append("Cannot map ").append(bsonValue).append(" bson value to json").toString(), errors.MongoJsonParsingException$.MODULE$.apply$default$2()));
    }

    public Json binaryBase64ToJson(String base64, String subType) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)json.Tag$.MODULE$.binary()), (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"base64"), (Object)Json$.MODULE$.fromString(base64)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subType"), (Object)Json$.MODULE$.fromString(subType))})))}));
    }

    public Json binaryArrayToJson(byte[] binary) {
        return this.binaryBase64ToJson(Base64.getEncoder().encodeToString(binary), "00");
    }

    public Json uuidToJson(UUID uuid) {
        return this.binaryBase64ToJson(Uuid$.MODULE$.toBase64(uuid), "04");
    }

    public Option<String> jsonToBinaryBase64(Json json2) {
        return ((JsonObject)((JsonObject)json2.asObject().get()).apply(json.Tag$.MODULE$.binary()).flatMap((Function1 & Serializable)x$14 -> x$14.asObject()).get()).apply("base64").flatMap((Function1 & Serializable)x$15 -> x$15.asString());
    }

    public UUID jsonToUuid(Json json2) {
        return Uuid$.MODULE$.fromBase64((String)this.jsonToBinaryBase64(json2).get());
    }

    public Json objectIdToJson(ObjectId id) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)json.Tag$.MODULE$.id()), (Object)Json$.MODULE$.fromString(id.toHexString()))}));
    }

    public Option<String> jsonToObjectIdString(Json json2) {
        return ((JsonObject)json2.asObject().get()).apply(json.Tag$.MODULE$.id()).flatMap((Function1 & Serializable)x$16 -> x$16.asString());
    }

    public Json instantToJson(Instant instant) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)json.Tag$.MODULE$.date()), (Object)Json$.MODULE$.fromString(instant.toString()))}));
    }

    public Json localDateToJson(LocalDate ld) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)json.Tag$.MODULE$.date()), (Object)Json$.MODULE$.fromString(ld.toString()))}));
    }

    public Option<String> jsonToDateString(Json json2) {
        return json2.asObject().flatMap((Function1 & Serializable)x$17 -> x$17.apply(json.Tag$.MODULE$.date())).flatMap((Function1 & Serializable)x$18 -> x$18.asString());
    }

    public static final /* synthetic */ boolean $anonfun$fromBson$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BsonValue v = (BsonValue)tuple2._2();
            return v.isUndefined();
        }
        throw new MatchError((Object)tuple2);
    }

    private CirceJsonMapper$() {
    }
}

