/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;

public class AssignOpExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final OperatorType operatorType;

    public AssignOpExpression(Expression left, Expression right, OperatorType operatorType) {
        this.left = left;
        this.right = right;
        this.operatorType = operatorType;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public Kind getKind() {
        return Kind.AssignOp;
    }

    @Override
    public String toString() {
        return this.left + " " + this.operatorType.getOperator() + " " + this.right;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AssignOpExpression that = (AssignOpExpression)obj;
        return this.left.equals(that.left) && this.right.equals(that.right) && this.operatorType.equals((Object)that.operatorType);
    }
}

