/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.util.List;

public class CaseExpression
extends Expression {
    private final Expression part;
    private final List<Expression> stats;

    public CaseExpression(Expression part, List<Expression> stats) {
        this.part = part;
        this.stats = stats;
    }

    public Expression getPart() {
        return this.part;
    }

    public List<Expression> getStats() {
        return this.stats;
    }

    @Override
    public Kind getKind() {
        return Kind.Case;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("case " + this.part + ":");
        block3: for (Expression stat : this.stats) {
            sb.append("\n    ").append(stat);
            switch (stat.getKind()) {
                case Block: 
                case Lambda: 
                case If: 
                case Foreach: 
                case For: 
                case While: 
                case Switch: 
                case Catch: 
                case Try: {
                    continue block3;
                }
            }
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CaseExpression that = (CaseExpression)obj;
        return this.part.equals(that.part) && this.stats.equals(that.stats);
    }
}

