/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;

public class ConstantExpression
extends Expression {
    private final Object value;
    private final Class<?> type;

    public ConstantExpression(Object value) {
        this.value = value;
        this.type = value == null ? Void.class : value.getClass();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Kind getKind() {
        return Kind.Constant;
    }

    @Override
    public String toString() {
        if (this.type == Character.TYPE || this.type == Character.class) {
            return "'" + this.value + "'";
        }
        if (this.type == String.class) {
            return "\"" + this.value + "\"";
        }
        return this.value.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)obj;
        if (that.value == null && this.type == Void.class) {
            return true;
        }
        return this.value.equals(that.value);
    }
}

