/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.AssignExpression;
import io.github.kiryu1223.expressionTree.expressions.AssignOpExpression;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.BreakExpression;
import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.ContinueExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.ForExpression;
import io.github.kiryu1223.expressionTree.expressions.ForeachExpression;
import io.github.kiryu1223.expressionTree.expressions.IfExpression;
import io.github.kiryu1223.expressionTree.expressions.IndexExpression;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewArrayExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.ReturnExpression;
import io.github.kiryu1223.expressionTree.expressions.StaticClassExpression;
import io.github.kiryu1223.expressionTree.expressions.SwitchExpression;
import io.github.kiryu1223.expressionTree.expressions.ThrowExpression;
import io.github.kiryu1223.expressionTree.expressions.TryExpression;
import io.github.kiryu1223.expressionTree.expressions.TypeCastExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.Visitor;
import io.github.kiryu1223.expressionTree.expressions.WhileExpression;
import java.util.List;

public class DeepFindVisitor
extends Visitor {
    protected void deep(Expression expression) {
        if (expression != null) {
            expression.accept(this);
        }
    }

    protected void deep(List<? extends Expression> expressions) {
        if (expressions != null) {
            for (Expression expression : expressions) {
                expression.accept(this);
            }
        }
    }

    @Override
    public void visit(BinaryExpression binaryExpression) {
        this.deep(binaryExpression.getLeft());
        this.deep(binaryExpression.getRight());
    }

    @Override
    public void visit(UnaryExpression unaryExpression) {
        this.deep(unaryExpression.getOperand());
    }

    @Override
    public void visit(ConstantExpression constantExpression) {
    }

    @Override
    public void visit(FieldSelectExpression fieldSelectExpression) {
        this.deep(fieldSelectExpression.getExpr());
    }

    @Override
    public void visit(MethodCallExpression methodCallExpression) {
        this.deep(methodCallExpression.getExpr());
        this.deep(methodCallExpression.getArgs());
    }

    @Override
    public void visit(ParameterExpression parameterExpression) {
    }

    @Override
    public void visit(NewExpression newExpression) {
        this.deep(newExpression.getConstructorArgs());
        this.deep(newExpression.getClassBody());
    }

    @Override
    public void visit(BlockExpression blockExpression) {
        this.deep(blockExpression.getExpressions());
    }

    @Override
    public void visit(LambdaExpression<?> lambdaExpression) {
        this.deep(lambdaExpression.getParameters());
        this.deep(lambdaExpression.getBody());
    }

    @Override
    public void visit(VariableExpression variableExpression) {
        this.deep(variableExpression.getInit());
        this.deep(variableExpression.getParameter());
    }

    @Override
    public void visit(NewArrayExpression newArrayExpression) {
        this.deep(newArrayExpression.getCounts());
        this.deep(newArrayExpression.getElems());
    }

    @Override
    public void visit(IndexExpression indexExpression) {
        this.deep(indexExpression.getObject());
        this.deep(indexExpression.getIndex());
    }

    @Override
    public void visit(AssignExpression assignExpression) {
        this.deep(assignExpression.getLeft());
        this.deep(assignExpression.getRight());
    }

    @Override
    public void visit(AssignOpExpression assignOpExpression) {
        this.deep(assignOpExpression.getLeft());
        this.deep(assignOpExpression.getRight());
    }

    @Override
    public void visit(ReferenceExpression referenceExpression) {
    }

    @Override
    public void visit(StaticClassExpression staticClassExpression) {
    }

    @Override
    public void visit(ReturnExpression returnExpression) {
        this.deep(returnExpression.getExpr());
    }

    @Override
    public void visit(BreakExpression breakExpression) {
    }

    @Override
    public void visit(ContinueExpression continueExpression) {
    }

    @Override
    public void visit(ConditionalExpression conditionalExpression) {
        this.deep(conditionalExpression.getCondition());
        this.deep(conditionalExpression.getTruePart());
        this.deep(conditionalExpression.getFalsePart());
    }

    @Override
    public void visit(IfExpression ifExpression) {
        this.deep(ifExpression.getCondition());
        this.deep(ifExpression.getThenPart());
        this.deep(ifExpression.getElsePart());
    }

    @Override
    public void visit(ParensExpression parensExpression) {
        this.deep(parensExpression.getExpr());
    }

    @Override
    public void visit(ForeachExpression foreachExpression) {
        this.deep(foreachExpression.getVar());
        this.deep(foreachExpression.getExpr());
        this.deep(foreachExpression.getBody());
    }

    @Override
    public void visit(ForExpression forExpression) {
        this.deep(forExpression.getInit());
        this.deep(forExpression.getCondition());
        this.deep(forExpression.getStep());
        this.deep(forExpression.getBody());
    }

    @Override
    public void visit(WhileExpression whileExpression) {
        this.deep(whileExpression.getCondition());
        this.deep(whileExpression.getBody());
    }

    @Override
    public void visit(SwitchExpression switchExpression) {
        this.deep(switchExpression.getSelector());
        this.deep(switchExpression.getCases());
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.deep(caseExpression.getPart());
        this.deep(caseExpression.getStats());
    }

    @Override
    public void visit(CatchExpression catchExpression) {
        this.deep(catchExpression.getParam());
        this.deep(catchExpression.getBody());
    }

    @Override
    public void visit(TryExpression tryExpression) {
        this.deep(tryExpression.getResources());
        this.deep(tryExpression.getBody());
        this.deep(tryExpression.getCatchers());
        this.deep(tryExpression.getFinalizer());
    }

    @Override
    public void visit(ThrowExpression throwExpression) {
        this.deep(throwExpression.getExpr());
    }

    @Override
    public void visit(TypeCastExpression typeCastExpression) {
        this.deep(typeCastExpression.getExpr());
    }
}

