/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.delegate.Delegate;
import io.github.kiryu1223.expressionTree.expressions.AssignExpression;
import io.github.kiryu1223.expressionTree.expressions.AssignOpExpression;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.BreakExpression;
import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.ContinueExpression;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.ForExpression;
import io.github.kiryu1223.expressionTree.expressions.ForeachExpression;
import io.github.kiryu1223.expressionTree.expressions.GenericsVisitor;
import io.github.kiryu1223.expressionTree.expressions.IfExpression;
import io.github.kiryu1223.expressionTree.expressions.IndexExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewArrayExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.ReturnExpression;
import io.github.kiryu1223.expressionTree.expressions.StaticClassExpression;
import io.github.kiryu1223.expressionTree.expressions.SwitchExpression;
import io.github.kiryu1223.expressionTree.expressions.ThrowExpression;
import io.github.kiryu1223.expressionTree.expressions.TryExpression;
import io.github.kiryu1223.expressionTree.expressions.TypeCastExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.Visitor;
import io.github.kiryu1223.expressionTree.expressions.WhileExpression;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Expression {
    public Object getValue() {
        return null;
    }

    protected boolean hasParameterExpression() {
        final AtomicBoolean flag = new AtomicBoolean(false);
        this.accept(new DeepFindVisitor(){

            @Override
            public void visit(ParameterExpression parameterExpression) {
                flag.set(true);
            }
        });
        return flag.get();
    }

    public abstract Kind getKind();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public <V> void accept(GenericsVisitor<V> visitor, V v) {
        visitor.visit(this, v);
    }

    public static BinaryExpression Binary(Expression left, Expression right, OperatorType operatorType) {
        return new BinaryExpression(left, right, operatorType);
    }

    public static UnaryExpression Unary(Expression operand, OperatorType operatorType) {
        return new UnaryExpression(operand, operatorType);
    }

    public static ConstantExpression Constant(Object value) {
        return new ConstantExpression(value);
    }

    public static FieldSelectExpression FieldSelect(Expression expr, Field field) {
        return new FieldSelectExpression(expr, field);
    }

    public static MethodCallExpression MethodCall(Expression expr, Method method, Expression[] args) {
        return new MethodCallExpression(expr, method, Arrays.asList(args));
    }

    public static ParameterExpression Parameter(Class<?> type, String name) {
        return new ParameterExpression(type, name);
    }

    public static NewExpression New(Class<?> type, Class<?>[] typeArgs, Constructor<?> constructor, Expression[] constructorArgs, BlockExpression body) {
        return new NewExpression(type, Arrays.asList(typeArgs), constructor, Arrays.asList(constructorArgs), body);
    }

    public static <T extends Delegate> LambdaExpression<T> Lambda(Expression body, ParameterExpression[] parameters, Class<?> returnType) {
        return new LambdaExpression(body, Arrays.asList(parameters), returnType);
    }

    public static BlockExpression Block(Expression[] expressions, ParameterExpression[] variables, boolean isStatic) {
        return new BlockExpression(Arrays.asList(expressions), Arrays.asList(variables), isStatic);
    }

    public static BlockExpression Block(Expression[] expressions, boolean isStatic) {
        return Expression.Block(expressions, new ParameterExpression[0], isStatic);
    }

    public static BlockExpression Block(Expression[] expressions) {
        return Expression.Block(expressions, false);
    }

    public static VariableExpression Variable(ParameterExpression parameter, Expression init) {
        return new VariableExpression(parameter, init);
    }

    public static VariableExpression Variable(ParameterExpression parameter) {
        return Expression.Variable(parameter, null);
    }

    public static NewArrayExpression NewArray(Class<?> type, Expression[] counts, Expression[] elems) {
        return new NewArrayExpression(type, Arrays.asList(counts), Arrays.asList(elems));
    }

    public static IndexExpression Index(Expression object, Expression index) {
        return new IndexExpression(object, index);
    }

    public static AssignExpression Assign(Expression left, Expression right) {
        return new AssignExpression(left, right);
    }

    public static AssignOpExpression AssignOp(Expression left, Expression right, OperatorType operatorType) {
        return new AssignOpExpression(left, right, operatorType);
    }

    public static StaticClassExpression StaticClass(Class<?> type) {
        return new StaticClassExpression(type);
    }

    public static ReferenceExpression Reference(Object ref, String name) {
        return new ReferenceExpression(ref, name, false);
    }

    public static ReferenceExpression Reference(Object ref, String name, boolean isPrimitive) {
        return new ReferenceExpression(ref, name, isPrimitive);
    }

    public static ReturnExpression Return(Expression expr) {
        return new ReturnExpression(expr);
    }

    public static BreakExpression Break() {
        return new BreakExpression();
    }

    public static ContinueExpression Continue() {
        return new ContinueExpression();
    }

    public static ConditionalExpression Conditional(Expression condition, Expression truePart, Expression falsePart) {
        return new ConditionalExpression(condition, truePart, falsePart);
    }

    public static IfExpression If(Expression condition, Expression thenPart, Expression elsePart) {
        return new IfExpression(condition, thenPart, elsePart);
    }

    public static IfExpression If(Expression condition, Expression thenPart) {
        return Expression.If(condition, thenPart, null);
    }

    public static IfExpression If(Expression condition) {
        return Expression.If(condition, null);
    }

    public static ParensExpression Parens(Expression expr) {
        return new ParensExpression(expr);
    }

    public static ForeachExpression Foreach(VariableExpression var, Expression expr, Expression body) {
        return new ForeachExpression(var, expr, body);
    }

    public static ForExpression For(Expression[] init, Expression condition, Expression[] step, Expression body) {
        return new ForExpression(Arrays.asList(init), condition, Arrays.asList(step), body);
    }

    public static WhileExpression While(Expression condition, Expression body) {
        return new WhileExpression(condition, body);
    }

    public static SwitchExpression Switch(Expression selector, CaseExpression[] cases) {
        return new SwitchExpression(selector, Arrays.asList(cases));
    }

    public static CaseExpression Case(Expression part, Expression[] stats) {
        return new CaseExpression(part, Arrays.asList(stats));
    }

    public static TryExpression Try(BlockExpression body, CatchExpression[] catchers, BlockExpression finalizer, Expression[] resources) {
        return new TryExpression(body, Arrays.asList(catchers), finalizer, Arrays.asList(resources));
    }

    public static TryExpression Try(BlockExpression body, CatchExpression[] catchers, Expression[] resources) {
        return Expression.Try(body, catchers, null, resources);
    }

    public static CatchExpression Catch(VariableExpression param, BlockExpression body) {
        return new CatchExpression(param, body);
    }

    public static ThrowExpression Throw(Expression expr) {
        return new ThrowExpression(expr);
    }

    public static TypeCastExpression TypeCast(StaticClassExpression staticClass, Expression expr) {
        return new TypeCastExpression(staticClass.getType(), expr);
    }
}

