/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.lang.reflect.Field;
import java.util.List;

public class FieldSelectExpression
extends Expression {
    private final Expression expr;
    private final Field field;

    public FieldSelectExpression(Expression expr, Field field) {
        this.expr = expr;
        this.field = field;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Object getValue() {
        if (this.hasParameterExpression()) {
            return null;
        }
        try {
            Object value = this.expr.getValue();
            return this.field.get(value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Kind getKind() {
        return Kind.FieldSelect;
    }

    @Override
    public String toString() {
        return this.expr + "." + this.field.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSelectExpression that = (FieldSelectExpression)obj;
        return this.expr.equals(that.expr) && this.field.equals(that.field);
    }

    public boolean inParameters(List<ParameterExpression> parameters) {
        if (this.expr instanceof ParameterExpression) {
            ParameterExpression parameter = (ParameterExpression)this.expr;
            return parameters.contains(parameter);
        }
        return false;
    }
}

