/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.util.List;

public class ForExpression
extends Expression {
    private final List<Expression> init;
    private final Expression condition;
    private final List<Expression> step;
    private final Expression body;

    public ForExpression(List<Expression> init, Expression condition, List<Expression> step, Expression body) {
        this.init = init;
        this.condition = condition;
        this.step = step;
        this.body = body;
    }

    public List<Expression> getInit() {
        return this.init;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public List<Expression> getStep() {
        return this.step;
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public Kind getKind() {
        return Kind.For;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("for (");
        for (Expression expression : this.init) {
            sb.append(expression);
        }
        sb.append(";");
        if (this.condition != null) {
            sb.append(this.condition);
        }
        sb.append(";");
        for (Expression expression : this.step) {
            sb.append(expression);
        }
        sb.append(") ").append(this.body);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ForExpression that = (ForExpression)obj;
        return this.init.equals(that.init) && this.condition.equals(that.condition) && this.step.equals(that.step) && this.body.equals(that.body);
    }
}

