/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression thenPart;
    private final Expression elsePart;

    public IfExpression(Expression condition, Expression thenPart, Expression elsePart) {
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getThenPart() {
        return this.thenPart;
    }

    public Expression getElsePart() {
        return this.elsePart;
    }

    @Override
    public Kind getKind() {
        return Kind.If;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("if ").append(this.condition).append(" ");
        if (this.thenPart != null) {
            sb.append(this.thenPart);
            sb.append(this.thenPart.getKind() == Kind.Block ? "" : ";");
        }
        if (this.elsePart != null) {
            sb.append("\n    ").append("else ").append(this.elsePart);
            sb.append(this.elsePart.getKind() == Kind.Block || this.elsePart.getKind() == Kind.If ? "" : ";");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression that = (IfExpression)obj;
        return this.condition.equals(that.condition) && this.thenPart.equals(that.thenPart) && this.elsePart.equals(that.elsePart);
    }
}

