/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.delegate.Delegate;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.util.List;

public class LambdaExpression<T extends Delegate>
extends Expression {
    private final Expression body;
    private final List<ParameterExpression> parameters;
    private final Class<?> returnType;

    public LambdaExpression(Expression body, List<ParameterExpression> parameters, Class<?> returnType) {
        this.body = body;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public Expression getBody() {
        return this.body;
    }

    public List<ParameterExpression> getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public Kind getKind() {
        return Kind.Lambda;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (ParameterExpression parameter : this.parameters) {
            sb.append(parameter.getName()).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(") -> ");
        sb.append(this.body);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaExpression that = (LambdaExpression)obj;
        return this.body.equals(that.body) && this.parameters.equals(that.parameters) && this.returnType.equals(that.returnType);
    }
}

