/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class MethodCallExpression
extends Expression {
    private final Expression expr;
    private final Method method;
    private final List<Expression> args;

    public MethodCallExpression(Expression expr, Method method, List<Expression> args) {
        this.expr = expr;
        this.method = method;
        this.args = args;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Method getMethod() {
        return this.method;
    }

    public List<Expression> getArgs() {
        return this.args;
    }

    @Override
    public Object getValue() {
        if (this.hasParameterExpression()) {
            return null;
        }
        try {
            Object thiz = this.expr.getValue();
            Object[] values = this.args.stream().map(m -> m.getValue()).toArray();
            return this.method.invoke(thiz, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Kind getKind() {
        return Kind.MethodCall;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.expr != null) {
            sb.append(this.expr).append(".");
        }
        sb.append(this.method.getName()).append("(");
        for (Expression arg : this.args) {
            sb.append(arg);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCallExpression that = (MethodCallExpression)obj;
        return this.expr.equals(that.expr) && this.method.equals(that.method) && this.args.equals(that.args);
    }

    public boolean inParameters(List<ParameterExpression> parameters) {
        if (this.expr instanceof ParameterExpression) {
            ParameterExpression parameter = (ParameterExpression)this.expr;
            return parameters.contains(parameter);
        }
        return false;
    }
}

