/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.util.List;

public class NewArrayExpression
extends Expression {
    private final Class<?> type;
    private final List<Expression> counts;
    private final List<Expression> elems;

    public NewArrayExpression(Class<?> type, List<Expression> counts, List<Expression> elems) {
        this.type = type;
        this.counts = counts;
        this.elems = elems;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Expression> getCounts() {
        return this.counts;
    }

    public List<Expression> getElems() {
        return this.elems;
    }

    @Override
    public Kind getKind() {
        return Kind.NewArray;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.type.getSimpleName());
        if (!this.counts.isEmpty()) {
            for (Expression count : this.counts) {
                sb.append("[").append(count).append("]");
            }
        } else {
            sb.append("[]");
        }
        if (!this.elems.isEmpty()) {
            sb.append("{");
            for (Expression elem : this.elems) {
                sb.append(elem).append(",");
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NewArrayExpression that = (NewArrayExpression)obj;
        return this.type.equals(that.type) && this.counts.equals(that.counts) && this.elems.equals(that.elems);
    }
}

