/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class NewExpression
extends Expression {
    private final Class<?> type;
    private final List<Class<?>> typeArgs;
    private final Constructor<?> constructor;
    private final List<Expression> constructorArgs;
    private final BlockExpression classBody;

    public NewExpression(Class<?> type, List<Class<?>> typeArgs, Constructor<?> constructor, List<Expression> constructorArgs, BlockExpression classBody) {
        this.type = type;
        this.typeArgs = typeArgs;
        this.constructor = constructor;
        this.constructorArgs = constructorArgs;
        this.classBody = classBody;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Class<?>> getTypeArgs() {
        return this.typeArgs;
    }

    public List<Expression> getConstructorArgs() {
        return this.constructorArgs;
    }

    public BlockExpression getClassBody() {
        return this.classBody;
    }

    @Override
    public Kind getKind() {
        return Kind.New;
    }

    @Override
    public Object getValue() {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression constructorArg : this.constructorArgs) {
                values.add(constructorArg.getValue());
            }
            Object[] array = values.toArray();
            return this.constructor.newInstance(array);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new ").append(this.type.isAnonymousClass() ? this.type.getSuperclass().getSimpleName() : this.type.getSimpleName()).append("(");
        for (Expression constructorArg : this.constructorArgs) {
            sb.append(constructorArg).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        if (this.classBody != null) {
            sb.append(this.classBody);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NewExpression that = (NewExpression)obj;
        return this.type.equals(that.type) && this.constructorArgs.equals(that.constructorArgs) && this.classBody.equals(that.classBody);
    }
}

