/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;

public class StaticClassExpression
extends Expression {
    private final Class<?> type;

    public StaticClassExpression(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Kind getKind() {
        return Kind.StaticClass;
    }

    @Override
    public String toString() {
        return this.type.getSimpleName() + ".class";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StaticClassExpression that = (StaticClassExpression)obj;
        return this.type.equals(that.type);
    }
}

