/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.util.List;

public class SwitchExpression
extends Expression {
    private final Expression selector;
    private final List<CaseExpression> cases;

    public SwitchExpression(Expression selector, List<CaseExpression> cases) {
        this.selector = selector;
        this.cases = cases;
    }

    public Expression getSelector() {
        return this.selector;
    }

    public List<CaseExpression> getCases() {
        return this.cases;
    }

    @Override
    public Kind getKind() {
        return Kind.Switch;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch ").append(this.selector).append(" ").append("{\n");
        for (CaseExpression aCase : this.cases) {
            sb.append("    ").append(aCase).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchExpression that = (SwitchExpression)obj;
        return this.selector.equals(that.selector) && this.cases.equals(that.cases);
    }
}

