/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import java.util.List;

public class TryExpression
extends Expression {
    private final BlockExpression body;
    private final List<CatchExpression> catchers;
    private final BlockExpression finalizer;
    private final List<Expression> resources;

    public TryExpression(BlockExpression body, List<CatchExpression> catchers, BlockExpression finalizer, List<Expression> resources) {
        this.body = body;
        this.catchers = catchers;
        this.finalizer = finalizer;
        this.resources = resources;
    }

    public BlockExpression getBody() {
        return this.body;
    }

    public List<CatchExpression> getCatchers() {
        return this.catchers;
    }

    public BlockExpression getFinalizer() {
        return this.finalizer;
    }

    public List<Expression> getResources() {
        return this.resources;
    }

    @Override
    public Kind getKind() {
        return Kind.Try;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("try");
        if (!this.resources.isEmpty()) {
            sb.append("(");
            for (Expression resource : this.resources) {
                sb.append(resource).append(";");
            }
            sb.append(")");
        }
        if (this.body != null) {
            sb.append(this.body);
        }
        for (CatchExpression catcher : this.catchers) {
            sb.append(catcher);
        }
        if (this.finalizer != null) {
            sb.append("finally").append(this.finalizer);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryExpression that = (TryExpression)obj;
        return this.body.equals(that.body) && this.catchers.equals(that.catchers) && this.finalizer.equals(that.finalizer) && this.resources.equals(that.resources);
    }
}

