/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;

public class TypeCastExpression
extends Expression {
    private final Class<?> targetType;
    private final Expression expr;

    public TypeCastExpression(Class<?> targetType, Expression expr) {
        this.targetType = targetType;
        this.expr = expr;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Expression getExpr() {
        return this.expr;
    }

    @Override
    public Kind getKind() {
        return Kind.TypeCast;
    }

    @Override
    public String toString() {
        return "(" + this.targetType.getSimpleName() + ")" + this.expr;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TypeCastExpression that = (TypeCastExpression)obj;
        return this.targetType.equals(that.targetType) && this.expr.equals(that.expr);
    }
}

