/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;

public class UnaryExpression
extends Expression {
    private final Expression operand;
    private final OperatorType operatorType;

    public UnaryExpression(Expression operand, OperatorType operatorType) {
        this.operand = operand;
        this.operatorType = operatorType;
    }

    public Expression getOperand() {
        return this.operand;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public Kind getKind() {
        return Kind.Unary;
    }

    @Override
    public String toString() {
        switch (this.operatorType) {
            case POSTINC: 
            case POSTDEC: {
                return this.operand + this.operatorType.getOperator();
            }
        }
        return this.operatorType.getOperator() + this.operand;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)obj;
        return this.operand.equals(that.operand) && this.operatorType.equals((Object)that.operatorType);
    }
}

