/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.expressions;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;

public class VariableExpression
extends Expression {
    private final ParameterExpression parameter;
    private final Expression init;

    public VariableExpression(ParameterExpression parameter, Expression init) {
        this.parameter = parameter;
        this.init = init;
    }

    public ParameterExpression getParameter() {
        return this.parameter;
    }

    public Expression getInit() {
        return this.init;
    }

    public String getName() {
        return this.parameter.getName();
    }

    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public Kind getKind() {
        return Kind.Variable;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parameter.getType().getSimpleName()).append(" ").append(this.parameter.getName());
        if (this.init != null) {
            sb.append(" = ").append(this.init);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VariableExpression that = (VariableExpression)obj;
        return this.parameter.equals(that.parameter) && this.init.equals(that.init);
    }
}

