/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.plugin;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import io.github.kiryu1223.expressionTree.expressions.annos.Getter;
import io.github.kiryu1223.expressionTree.expressions.annos.Setter;
import io.github.kiryu1223.expressionTree.ext.IExtensionService;
import io.github.kiryu1223.expressionTree.plugin.LambdaTrans;
import io.github.kiryu1223.expressionTree.util.JDK;
import io.github.kiryu1223.expressionTree.util.ReflectUtil;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public class ExprTreeTaskListener
implements TaskListener {
    private final TreeMaker treeMaker;
    private final Types types;
    private final Names names;
    private final Context context;
    private final Symtab symtab;
    private final ClassReader classReader;
    private final java.util.List<IExtensionService> extensionServices;

    public ExprTreeTaskListener(Context context) {
        this.treeMaker = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.names = Names.instance(context);
        this.symtab = Symtab.instance(context);
        this.classReader = ClassReader.instance(context);
        this.context = context;
        this.extensionServices = this.registrarExtensionService(context);
    }

    private java.util.List<IExtensionService> registrarExtensionService(Context context) {
        ServiceLoader<IExtensionService> load = ServiceLoader.load(IExtensionService.class, ExprTreeTaskListener.class.getClassLoader());
        ArrayList<IExtensionService> iExtensionServices = new ArrayList<IExtensionService>();
        for (IExtensionService iExtensionService : load) {
            iExtensionService.init(context);
            iExtensionServices.add(iExtensionService);
        }
        return iExtensionServices;
    }

    private void startedCallExtensionServices(TaskEvent event) throws Throwable {
        for (IExtensionService extensionService : this.extensionServices) {
            extensionService.started(event);
        }
    }

    private void finishedCallExtensionServices(TaskEvent event) throws Throwable {
        for (IExtensionService extensionService : this.extensionServices) {
            extensionService.finished(event);
        }
    }

    @Override
    public void started(TaskEvent event) {
        try {
            this.startedCallExtensionServices(event);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finished(TaskEvent event) {
        try {
            this.getterOrSetter(event);
            this.blockTaskMake(event);
            this.lambdaToTree(event);
            this.finishedCallExtensionServices(event);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void lambdaToTree(TaskEvent event) {
        if (event.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)event.getCompilationUnit();
        Object moduleSymbol = null;
        if (JDK.is9orLater()) {
            moduleSymbol = ReflectUtil.getFieldValue(compilationUnit, "modle");
        }
        for (JCTree tree : compilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            classDecl.accept(new LambdaTrans(this.treeMaker, this.types, this.names, this.symtab, this.classReader, moduleSymbol));
        }
    }

    private void blockTaskMake(TaskEvent event) {
        if (event.getKind() != TaskEvent.Kind.PARSE) {
            return;
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)event.getCompilationUnit();
        for (JCTree tree : compilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            classDecl.accept(new TreeScanner(){

                @Override
                public void visitMethodDef(JCTree.JCMethodDecl tree) {
                }

                @Override
                public void visitBlock(JCTree.JCBlock block) {
                    ExprTreeTaskListener.this.treeMaker.at(block.pos);
                    JCTree.JCVariableDecl variableDecl = ExprTreeTaskListener.this.treeMaker.VarDef(ExprTreeTaskListener.this.treeMaker.Modifiers(0L), ExprTreeTaskListener.this.names.fromString("taskMake"), ExprTreeTaskListener.this.treeMaker.TypeIdent(TypeTag.INT), null);
                    ListBuffer<JCTree.JCVariableDecl> expressions = new ListBuffer<JCTree.JCVariableDecl>();
                    expressions.add(variableDecl);
                    expressions.addAll(block.getStatements());
                    block.stats = expressions.toList();
                }
            });
        }
    }

    private void getterOrSetter(TaskEvent event) {
        if (event.getKind() != TaskEvent.Kind.ENTER) {
            return;
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)event.getCompilationUnit();
        java.util.List imports = compilationUnit.getImports();
        for (JCTree tree : compilationUnit.getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            classDecl.accept(new TreeScanner((List)imports){
                final /* synthetic */ List val$imports;
                {
                    this.val$imports = list;
                }

                @Override
                public void visitNewClass(JCTree.JCNewClass newClass) {
                    if (newClass.getClassBody() != null) {
                        Setter setter;
                        JCTree.JCImport anImport = ExprTreeTaskListener.this.getImport(newClass.clazz.toString(), this.val$imports);
                        if (anImport == null) {
                            return;
                        }
                        Type type = ((JCTree)ReflectUtil.getFieldValue((Object)anImport, (String)"qualid")).type;
                        if (type == null) {
                            return;
                        }
                        Symbol.TypeSymbol tsym = type.tsym;
                        if (tsym == null) {
                            return;
                        }
                        JCTree.JCClassDecl classBody = newClass.getClassBody();
                        ListBuffer<JCTree.JCVariableDecl> variableDecls = new ListBuffer<JCTree.JCVariableDecl>();
                        ArrayList<String> methodDecls = new ArrayList<String>();
                        for (Object member : classBody.getMembers()) {
                            if (member instanceof JCTree.JCVariableDecl) {
                                JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)member;
                                variableDecls.add(jcVariableDecl);
                                continue;
                            }
                            if (!(member instanceof JCTree.JCMethodDecl)) continue;
                            JCTree.JCMethodDecl jcMethodDecl = (JCTree.JCMethodDecl)member;
                            methodDecls.add(jcMethodDecl.getName().toString());
                        }
                        Getter getter = tsym.getAnnotation(Getter.class);
                        if (getter != null) {
                            ExprTreeTaskListener.this.treeMaker.at(newClass.pos);
                            for (JCTree.JCVariableDecl variableDecl : variableDecls) {
                                String name = variableDecl.getName().toString();
                                String get = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                                if (methodDecls.contains(get)) continue;
                                JCTree.JCMethodDecl jcMethodDecl = ExprTreeTaskListener.this.treeMaker.MethodDef(ExprTreeTaskListener.this.treeMaker.Modifiers(1L), ExprTreeTaskListener.this.names.fromString(get), variableDecl.vartype, List.nil(), List.nil(), List.nil(), ExprTreeTaskListener.this.treeMaker.Block(0L, List.of(ExprTreeTaskListener.this.treeMaker.Return(ExprTreeTaskListener.this.treeMaker.Ident(variableDecl.getName())))), null);
                                classBody.defs = classBody.defs.append(jcMethodDecl);
                            }
                        }
                        if ((setter = tsym.getAnnotation(Setter.class)) != null) {
                            ExprTreeTaskListener.this.treeMaker.at(newClass.pos);
                            for (JCTree.JCVariableDecl variableDecl : variableDecls) {
                                String name = variableDecl.getName().toString();
                                String set = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
                                if (methodDecls.contains(set)) continue;
                                JCTree.JCMethodDecl jcMethodDecl = ExprTreeTaskListener.this.treeMaker.MethodDef(ExprTreeTaskListener.this.treeMaker.Modifiers(1L), ExprTreeTaskListener.this.names.fromString("set" + name.substring(0, 1).toUpperCase() + name.substring(1)), ExprTreeTaskListener.this.treeMaker.TypeIdent(TypeTag.VOID), List.nil(), List.of(ExprTreeTaskListener.this.treeMaker.VarDef(ExprTreeTaskListener.this.treeMaker.Modifiers(0x200000000L), variableDecl.getName(), variableDecl.vartype, null)), List.nil(), ExprTreeTaskListener.this.treeMaker.Block(0L, List.of(ExprTreeTaskListener.this.treeMaker.Exec(ExprTreeTaskListener.this.treeMaker.Assign(ExprTreeTaskListener.this.treeMaker.Select((JCTree.JCExpression)ExprTreeTaskListener.this.treeMaker.Ident(((ExprTreeTaskListener)ExprTreeTaskListener.this).names._this), variableDecl.getName()), ExprTreeTaskListener.this.treeMaker.Ident(variableDecl.getName()))))), null);
                                classBody.defs = classBody.defs.append(jcMethodDecl);
                            }
                        }
                    }
                }
            });
        }
    }

    private JCTree.JCImport getImport(String simpleName, java.util.List<JCTree.JCImport> imports) {
        java.util.List collect = imports.stream().filter(i -> !i.isStatic() && ((JCTree)ReflectUtil.getFieldValue(i, "qualid")).toString().endsWith("." + simpleName)).collect(Collectors.toList());
        if (collect.size() != 1) {
            return null;
        }
        return (JCTree.JCImport)collect.get(0);
    }
}

