/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.plugin;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import io.github.kiryu1223.expressionTree.expressions.annos.Expr;
import io.github.kiryu1223.expressionTree.plugin.LambdaTranslator;
import io.github.kiryu1223.expressionTree.util.ReflectUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class LambdaFinder
extends TreeTranslator {
    private final TreeMaker treeMaker;
    private final Types types;
    private final Names names;
    private final Symtab symtab;
    private final ClassReader classReader;
    private final Object moduleSymbol;
    private final ArrayDeque<Symbol> thizDeque = new ArrayDeque();
    private final ArrayDeque<Symbol> ownerDeque = new ArrayDeque();
    private final ArrayDeque<Symbol.VarSymbol> varSymbolDeque = new ArrayDeque();
    private final ArrayDeque<ListBuffer<JCTree.JCStatement>> statementsDeque = new ArrayDeque();
    private final AtomicInteger argIndex = new AtomicInteger();

    public LambdaFinder(TreeMaker treeMaker, Types types, Names names, Symtab symtab, ClassReader classReader, Object moduleSymbol) {
        this.treeMaker = treeMaker;
        this.types = types;
        this.names = names;
        this.symtab = symtab;
        this.classReader = classReader;
        this.moduleSymbol = moduleSymbol;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.thizDeque.push(tree.sym);
        super.visitClassDef(tree);
        this.thizDeque.pop();
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this.ownerDeque.push(tree.sym);
        super.visitMethodDef(tree);
        this.ownerDeque.pop();
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        if (!tree.isStatic() && !this.ownerDeque.isEmpty()) {
            ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
            this.statementsDeque.push(statements);
            for (JCTree.JCStatement stat : tree.stats) {
                statements.add(this.translate(stat));
            }
            this.statementsDeque.pop();
            tree.stats = statements.toList();
            this.result = tree;
        } else {
            super.visitBlock(tree);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        tree.meth = this.translate(tree.meth);
        Symbol.MethodSymbol methodSymbol = this.methodInvocationGetMethodSymbol(tree);
        java.util.List parameters = methodSymbol.getParameters();
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        java.util.List jcExpressions = tree.getArguments();
        boolean changed = false;
        ListBuffer<Type> argsType = new ListBuffer<Type>();
        for (int i = 0; i < ((List)jcExpressions).size(); ++i) {
            JCTree.JCExpression arg = (JCTree.JCExpression)((List)jcExpressions).get(i);
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((List)parameters).get(i);
            this.varSymbolDeque.push(varSymbol);
            if (arg instanceof JCTree.JCLambda && varSymbol.getAnnotation(Expr.class) != null) {
                changed = true;
            }
            JCTree.JCExpression translate = this.translate(arg);
            argsType.add(translate.type);
            args.add(translate);
            this.varSymbolDeque.pop();
        }
        if (changed) {
            Symbol.MethodSymbol targetMethodSymbol = this.getTargetMethodSymbol(methodSymbol, argsType);
            this.trySetMethodSymbol(tree, targetMethodSymbol);
        }
        tree.args = args.toList();
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        if (this.ownerDeque.isEmpty() || this.varSymbolDeque.isEmpty()) {
            this.tryOpenLambda(tree);
            super.visitLambda(tree);
        } else {
            Symbol.VarSymbol varSymbol = this.varSymbolDeque.peek();
            if (varSymbol.getAnnotation(Expr.class) != null) {
                LambdaTranslator lambdaTranslator = new LambdaTranslator(this.treeMaker, this.types, this.names, this.symtab, this.classReader, this.moduleSymbol, this.thizDeque, this.ownerDeque, this.varSymbolDeque, this.statementsDeque, this.argIndex);
                this.result = lambdaTranslator.translateToExprTree(tree);
            } else {
                this.tryOpenLambda(tree);
                super.visitLambda(tree);
            }
        }
    }

    private Symbol.MethodSymbol methodInvocationGetMethodSymbol(JCTree.JCMethodInvocation tree) {
        Symbol.MethodSymbol methodSymbol;
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        } else {
            JCTree.JCIdent select = (JCTree.JCIdent)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        }
        return methodSymbol;
    }

    private void tryOpenLambda(JCTree.JCLambda tree) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            JCTree.JCExpression body = (JCTree.JCExpression)tree.getBody();
            Type lambdaReturnType = this.getLambdaReturnType(tree);
            if (lambdaReturnType == this.symtab.voidType) {
                JCTree.JCExpressionStatement exec = this.treeMaker.Exec(body);
                tree.body = this.treeMaker.Block(0L, List.of(exec));
            } else {
                JCTree.JCReturn aReturn = this.treeMaker.Return(body);
                tree.body = this.treeMaker.Block(0L, List.of(aReturn));
            }
        }
    }

    private Type getLambdaReturnType(JCTree.JCLambda lambda) {
        Type descriptorType = this.types.findDescriptorType(lambda.type);
        Type.MethodType methodType = descriptorType.asMethodType();
        return methodType.getReturnType();
    }

    private boolean typesEqual(java.util.List<Type> left, java.util.List<Type> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            Type leftType = left.get(i);
            Type rightType = right.get(i);
            if (leftType.toString().equals(rightType.toString())) continue;
            return false;
        }
        return true;
    }

    private Symbol.MethodSymbol getTargetMethodSymbol(Symbol.MethodSymbol methodSymbol, ListBuffer<Type> argsType) {
        Symbol location = methodSymbol.location();
        for (Symbol enclosedElement : location.getEnclosedElements()) {
            Object parameter2;
            Symbol.MethodSymbol element;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(element = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodSymbol.getSimpleName()) || ((List)element.getParameters()).size() != ((List)methodSymbol.getParameters()).size()) continue;
            ArrayList<Type> varTypes = new ArrayList<Type>();
            for (Object parameter2 : element.getParameters()) {
                varTypes.add(this.types.erasure((Type)((Symbol.VarSymbol)parameter2).asType()));
            }
            ArrayList<Type> argTypes = new ArrayList<Type>();
            parameter2 = argsType.iterator();
            while (parameter2.hasNext()) {
                Type type = (Type)parameter2.next();
                argTypes.add(this.types.erasure(type));
            }
            boolean subtypes = this.typesEqual(varTypes, argTypes);
            if (!subtypes) continue;
            return element;
        }
        throw new RuntimeException();
    }

    private void trySetMethodSymbol(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol methodSymbol) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        tree.setType(methodSymbol.getReturnType());
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)methodSelect;
            tree.meth = this.refMakeSelector(select.getExpression(), methodSymbol);
        } else {
            JCTree.JCIdent select = (JCTree.JCIdent)methodSelect;
            tree.meth = this.treeMaker.Ident(methodSymbol);
        }
    }

    private JCTree.JCFieldAccess refMakeSelector(JCTree.JCExpression base, Symbol sym) {
        return (JCTree.JCFieldAccess)ReflectUtil.invokeMethod(this.treeMaker, "Select", Arrays.asList(base, sym));
    }
}

