/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.plugin;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import io.github.kiryu1223.expressionTree.delegate.Delegate;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.annos.Expr;
import io.github.kiryu1223.expressionTree.util.JDK;
import io.github.kiryu1223.expressionTree.util.ReflectUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public class LambdaTranslator
extends TreeTranslator {
    private final TreeMaker treeMaker;
    private final Types types;
    private final Names names;
    private final Symtab symtab;
    private final ClassReader classReader;
    private final Object moduleSymbol;
    private final ArrayDeque<Symbol> thizDeque;
    private final ArrayDeque<Symbol> ownerDeque;
    private final ArrayDeque<Symbol.VarSymbol> varSymbolDeque;
    private final ArrayDeque<ListBuffer<JCTree.JCStatement>> statementsDeque;
    private final AtomicInteger argIndex;
    private final Map<Name, JCTree.JCVariableDecl> lambdaVarMap = new HashMap<Name, JCTree.JCVariableDecl>();
    private final Map<JCTree.JCLambda, JCTree.JCVariableDecl> lambdaCache = new HashMap<JCTree.JCLambda, JCTree.JCVariableDecl>();
    private final ArrayDeque<ListBuffer<Name>> argNameDeque = new ArrayDeque();

    public LambdaTranslator(TreeMaker treeMaker, Types types, Names names, Symtab symtab, ClassReader classReader, Object moduleSymbol, ArrayDeque<Symbol> thizDeque, ArrayDeque<Symbol> ownerDeque, ArrayDeque<Symbol.VarSymbol> varSymbolDeque, ArrayDeque<ListBuffer<JCTree.JCStatement>> statementsDeque, AtomicInteger argIndex) {
        this.treeMaker = treeMaker;
        this.types = types;
        this.names = names;
        this.symtab = symtab;
        this.classReader = classReader;
        this.moduleSymbol = moduleSymbol;
        this.thizDeque = thizDeque;
        this.ownerDeque = ownerDeque;
        this.varSymbolDeque = varSymbolDeque;
        this.statementsDeque = statementsDeque;
        this.argIndex = argIndex;
    }

    public JCTree.JCExpression translateToExprTree(JCTree.JCLambda tree) {
        JCTree.JCExpression expression = this.translateV(tree);
        Symbol.MethodSymbol exprSymbol = this.getMethodSymbol(ExprTree.class, "Expr", Arrays.asList(Delegate.class, LambdaExpression.class));
        JCTree.JCFieldAccess fa = this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ExprTree.class)), exprSymbol);
        return this.treeMaker.App(fa, List.of(tree, expression));
    }

    public JCTree.JCExpression translateV(JCTree tree) {
        if (tree == null) {
            return null;
        }
        tree.accept(this);
        JCTree tmpResult = this.result;
        this.result = null;
        return (JCTree.JCExpression)tmpResult;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression select;
        ListBuffer<JCTree.JCExpression> of = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        Symbol.MethodSymbol methodSymbol = this.methodInvocationGetMethodSymbol(tree);
        java.util.List parameters = methodSymbol.getParameters();
        java.util.List jcExpressions = tree.getArguments();
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCExpression> newCode = new ListBuffer<JCTree.JCExpression>();
        boolean changed = false;
        ListBuffer<Type> argsType = new ListBuffer<Type>();
        for (int i = 0; i < ((List)jcExpressions).size(); ++i) {
            JCTree.JCExpression arg = (JCTree.JCExpression)((List)jcExpressions).get(i);
            this.varSymbolDeque.push((Symbol.VarSymbol)((List)parameters).get(i));
            JCTree.JCExpression jcExpression = this.translateV(arg);
            args.add(jcExpression);
            if (arg instanceof JCTree.JCLambda && this.lambdaCache.containsKey(arg)) {
                JCTree.JCLambda jcLambda = (JCTree.JCLambda)arg;
                Symbol.MethodSymbol exprSymbol = this.getMethodSymbol(ExprTree.class, "Expr", Arrays.asList(Delegate.class, LambdaExpression.class));
                JCTree.JCFieldAccess fa = this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ExprTree.class)), exprSymbol);
                JCTree.JCMethodInvocation apply = this.treeMaker.App(fa, List.of(jcLambda, jcExpression));
                newCode.add(apply);
                changed = true;
                argsType.add(apply.type);
            } else {
                newCode.add(arg);
                argsType.add(arg.type);
            }
            this.varSymbolDeque.pop();
        }
        if (changed) {
            Symbol.MethodSymbol targetMethodSymbol = this.getTargetMethodSymbol(methodSymbol, argsType);
            this.trySetMethodSymbol(tree, targetMethodSymbol);
        }
        tree.args = newCode.toList();
        String methodName = methodSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)methodSelect).getIdentifier().toString() : methodSelect.toString();
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        for (Type parameterType : methodSelect.type.asMethodType().getParameterTypes()) {
            ts.add(this.treeMaker.ClassLiteral(parameterType));
        }
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            select = (JCTree.JCFieldAccess)methodSelect;
            of.append(this.translateV(select.getExpression()));
        } else if (methodSelect instanceof JCTree.JCIdent) {
            select = (JCTree.JCIdent)methodSelect;
            if (methodSymbol.isStatic()) {
                of.append(this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(methodSymbol.location().asType()))));
            } else {
                of.append(this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(this.treeMaker.This(this.thizDeque.peek().type), this.treeMaker.Literal("this"))));
            }
        } else {
            throw new RuntimeException("\u610f\u6599\u4e4b\u5916\u7684\u7684\u8868\u8fbe\u5f0f:" + tree);
        }
        of.append(this.reflectMethod(methodSymbol.location().asType(), methodName, ts)).append((JCTree.JCMethodInvocation)((Object)this.makeArray(Expression.class, args.toList())));
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.MethodCall, Arrays.asList(Expression.class, Method.class, Expression[].class)), of.toList());
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        Symbol.VarSymbol varSymbol = this.varSymbolDeque.peek();
        if (varSymbol.getAnnotation(Expr.class) == null) {
            this.tryOpenLambda(tree);
            tree.body = this.translate(tree.body);
            this.result = tree;
        } else {
            Expr expr = varSymbol.getAnnotation(Expr.class);
            this.checkBody(expr.value(), tree.getBodyKind(), tree);
            ListBuffer<JCTree.JCStatement> peek = this.statementsDeque.peek();
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCVariableDecl param : tree.params) {
                JCTree.JCVariableDecl localVar = this.getLocalVar(param.type, param.getName().toString());
                peek.add(localVar);
                this.lambdaVarMap.put(param.name, localVar);
                args.add(this.treeMaker.Ident(localVar));
            }
            JCTree.JCExpression expression = this.translateV(tree.body);
            Type.MethodType methodType = this.types.findDescriptorType(tree.type).asMethodType();
            Type returnType = methodType.getReturnType();
            JCTree.JCVariableDecl localLambdaExpr = this.getLocalLambdaExpr(expression, args, returnType, tree.type);
            peek.add(localLambdaExpr);
            this.lambdaCache.put(tree, localLambdaExpr);
            JCTree.JCExpression ident = this.treeMaker.Ident(localLambdaExpr);
            this.result = ident;
            for (JCTree.JCVariableDecl param : tree.params) {
                this.lambdaVarMap.remove(param.name);
            }
        }
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        ListBuffer locals = new ListBuffer();
        this.argNameDeque.push(locals);
        for (JCTree statement : tree.getStatements()) {
            args.append(this.translateV(statement));
        }
        for (Name local : locals) {
            this.lambdaVarMap.remove(local);
        }
        this.argNameDeque.pop();
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Block, Arrays.asList(Expression[].class, Boolean.TYPE)), List.of(this.makeArray(Expression.class, args.toList()), this.treeMaker.Literal(tree.isStatic())));
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        ListBuffer<JCTree.JCStatement> statements = this.statementsDeque.peek();
        ListBuffer<Name> peek = this.argNameDeque.peek();
        Name name = tree.getName();
        JCTree.JCVariableDecl localVar = this.getLocalVar(tree.type, name.toString());
        peek.add(name);
        this.lambdaVarMap.put(name, localVar);
        statements.add(localVar);
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        args.append(this.treeMaker.Ident(this.lambdaVarMap.get(tree.getName())));
        JCTree.JCExpression initializer = tree.getInitializer();
        if (initializer != null) {
            args.append(this.translateV(initializer));
        } else {
            args.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Variable, Arrays.asList(ParameterExpression.class, Expression.class)), args.toList());
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(tree.type)));
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (tree.sym.getKind().isClass() || tree.sym.getKind().isInterface()) {
            this.result = this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(tree.type)));
        } else if (this.lambdaVarMap.containsKey(tree.getName())) {
            JCTree.JCVariableDecl jcVariableDecl = this.lambdaVarMap.get(tree.getName());
            this.result = this.treeMaker.Ident(jcVariableDecl);
        } else {
            this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(tree, this.treeMaker.Literal(tree.getName().toString())));
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Constant, Collections.singletonList(Object.class)), List.of(tree));
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        JCTree.JCExpression left = tree.getExpression();
        Name right = tree.getIdentifier();
        this.result = tree.sym.getKind() == ElementKind.FIELD && tree.getIdentifier().toString().equals("class") ? this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(left.type))) : this.treeMaker.App(this.getFactoryMethod(Kind.FieldSelect, Arrays.asList(Expression.class, Field.class)), List.of(this.translateV(left), this.reflectField(left.type, right.toString())));
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        JCTree.JCExpression expr = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Parens, Collections.singletonList(Expression.class)), List.of(expr));
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        JCTree.JCExpression left = this.translateV(tree.getLeftOperand());
        JCTree.JCExpression right = this.translateV(tree.getRightOperand());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Binary, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(tree.getTag())));
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        JCTree.JCExpression expr = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Unary, Arrays.asList(Expression.class, OperatorType.class)), List.of(expr, this.getOperator(tree.getTag())));
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.result = this.translateV(tree.getExpression());
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        JCTree.JCExpression cond = this.translateV(tree.getCondition());
        JCTree.JCExpression ifTrue = this.translateV(tree.getTrueExpression());
        JCTree.JCExpression ifFalse = this.translateV(tree.getFalseExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Conditional, Arrays.asList(Expression.class, Expression.class, Expression.class)), List.of(cond, ifTrue, ifFalse));
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        JCTree.JCExpression left = this.translateV(tree.getVariable());
        JCTree.JCExpression right = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Assign, Arrays.asList(Expression.class, Expression.class)), List.of(left, right));
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        JCTree.JCExpression left = this.translateV(tree.getVariable());
        JCTree.JCExpression right = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.AssignOp, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(tree.getTag())));
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        JCTree.JCExpression cond = this.translateV(tree.getCondition());
        args.append(cond);
        if (tree.getThenStatement() != null) {
            JCTree.JCExpression then = this.translateV(tree.getThenStatement());
            args.append(then);
        } else {
            args.append(this.getNull());
        }
        if (tree.getElseStatement() != null) {
            JCTree.JCExpression elSe = this.translateV(tree.getElseStatement());
            args.append(elSe);
        } else {
            args.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.If, Arrays.asList(Expression.class, Expression.class, Expression.class)), args.toList());
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        JCTree.JCExpression indexed = this.translateV(tree.getExpression());
        JCTree.JCExpression index = this.translateV(tree.getIndex());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Index, Arrays.asList(Expression.class, Expression.class)), List.of(indexed, index));
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        ArrayList classes = new ArrayList(4);
        ListBuffer<JCTree.JCExpression> all = new ListBuffer<JCTree.JCExpression>();
        classes.add(Class.class);
        all.append(this.treeMaker.ClassLiteral(tree.type));
        ListBuffer<JCTree.JCExpression> typeArgs = new ListBuffer<JCTree.JCExpression>();
        if (tree.getIdentifier() instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)tree.getIdentifier();
            for (Object typeArgument : typeApply.getTypeArguments()) {
                typeArgs.append(this.treeMaker.ClassLiteral(((JCTree.JCExpression)typeArgument).type));
            }
        }
        classes.add(Class[].class);
        all.append(this.makeArray(Class.class, typeArgs.toList()));
        classes.add(Constructor.class);
        Symbol.MethodSymbol init = (Symbol.MethodSymbol)tree.constructor;
        ListBuffer<JCTree.JCExpression> types = new ListBuffer<JCTree.JCExpression>();
        for (Object parameter : init.getParameters()) {
            types.add(this.treeMaker.ClassLiteral((Type)((Symbol.VarSymbol)parameter).asType()));
        }
        all.append(this.reflectConstructor(tree.type, types));
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCExpression argument : tree.getArguments()) {
            args.append(this.translateV(argument));
        }
        classes.add(Expression[].class);
        all.append(this.makeArray(Expression.class, args.toList()));
        JCTree.JCClassDecl classBody = tree.getClassBody();
        classes.add(BlockExpression.class);
        if (classBody != null) {
            ListBuffer<JCTree.JCExpression> body = new ListBuffer<JCTree.JCExpression>();
            for (JCTree member : classBody.getMembers()) {
                if (!(member instanceof JCTree.JCVariableDecl)) continue;
                JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)member;
                JCTree.JCExpression variable = this.translateV(variableDecl);
                body.add(variable);
            }
            all.append(this.treeMaker.App(this.getFactoryMethod(Kind.Block, Collections.singletonList(Expression[].class)), List.of(this.makeArray(Expression.class, body.toList()))));
        } else {
            all.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.New, classes), all.toList());
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCExpression dimension : tree.getDimensions()) {
            dims.append(this.translateV(dimension));
        }
        for (JCTree.JCExpression initializer : tree.getInitializers()) {
            args.append(this.translateV(initializer));
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.NewArray, Arrays.asList(Class.class, Expression[].class, Expression[].class)), List.of(this.treeMaker.ClassLiteral(tree.getType().type), this.makeArray(Expression.class, dims.toList()), this.makeArray(Expression.class, args.toList())));
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        JCTree.JCExpression rt = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Return, Collections.singletonList(Expression.class)), List.of(rt));
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Break, Collections.emptyList()));
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Continue, Collections.emptyList()));
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCExpression> inits = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCStatement jcStatement : tree.getInitializer()) {
            inits.append(this.translateV(jcStatement));
        }
        args.append(this.makeArray(Expression.class, inits.toList()));
        if (tree.getCondition() != null) {
            args.append(this.translateV(tree.getCondition()));
        } else {
            args.append(this.getNull());
        }
        ListBuffer<JCTree.JCExpression> steps = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCExpressionStatement expressionStatement : tree.getUpdate()) {
            steps.append(this.translateV(expressionStatement));
        }
        args.append(this.makeArray(Expression.class, steps.toList()));
        if (tree.getStatement() != null) {
            args.append(this.translateV(tree.getStatement()));
        } else {
            args.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.For, Arrays.asList(Expression[].class, Expression.class, Expression[].class, Expression.class)), args.toList());
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        JCTree.JCExpression var = this.translateV(tree.getVariable());
        JCTree.JCExpression expr = this.translateV(tree.getExpression());
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        args.append(var).append(expr);
        if (tree.getStatement() != null) {
            args.append(this.translateV(tree.getStatement()));
        } else {
            args.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Foreach, Arrays.asList(VariableExpression.class, Expression.class, Expression.class)), args.toList());
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        args.append(this.translateV(tree.getCondition()));
        if (tree.getStatement() != null) {
            args.append(this.translateV(tree.getStatement()));
        } else {
            args.append(this.getNull());
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.While, Arrays.asList(Expression.class, Expression.class)), args.toList());
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        JCTree.JCExpression selector = this.translateV(tree.getExpression());
        ListBuffer<JCTree.JCExpression> cases = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCCase aCase : tree.getCases()) {
            cases.append(this.translateV(aCase));
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Switch, Arrays.asList(Expression.class, CaseExpression[].class)), List.of(selector, this.makeArray(CaseExpression.class, cases.toList())));
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        JCTree.JCExpression part = this.translateV(tree.getExpression());
        ListBuffer<JCTree.JCExpression> stats = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCStatement statement : tree.getStatements()) {
            stats.append(this.translateV(statement));
        }
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Case, Arrays.asList(Expression.class, Expression[].class)), List.of(part, this.makeArray(Expression.class, stats.toList())));
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        args.append(this.translateV(tree.getBlock()));
        ListBuffer<JCTree.JCExpression> catches = new ListBuffer<JCTree.JCExpression>();
        for (JCTree.JCCatch aCatch : tree.getCatches()) {
            catches.append(this.translateV(aCatch));
        }
        args.append(this.makeArray(CatchExpression.class, catches.toList()));
        if (tree.getFinallyBlock() != null) {
            args.append(this.translateV(tree.getFinallyBlock()));
        } else {
            args.append(this.getNull());
        }
        ListBuffer<JCTree.JCExpression> resources = new ListBuffer<JCTree.JCExpression>();
        for (JCTree resource : tree.getResources()) {
            resources.append(this.translateV(resource));
        }
        args.append(this.makeArray(Expression.class, resources.toList()));
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Try, Arrays.asList(BlockExpression.class, CatchExpression[].class, BlockExpression.class, Expression[].class)), args.toList());
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        JCTree.JCExpression param = this.translateV(tree.getParameter());
        JCTree.JCExpression body = this.translateV(tree.getBlock());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Catch, Arrays.asList(VariableExpression.class, BlockExpression.class)), List.of(param, body));
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        JCTree.JCExpression expr = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.Throw, Collections.singletonList(Expression.class)), List.of(expr));
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        JCTree.JCExpression target = this.translateV(tree.getType());
        JCTree.JCExpression expr = this.translateV(tree.getExpression());
        this.result = this.treeMaker.App(this.getFactoryMethod(Kind.TypeCast, Arrays.asList(Class.class, Expression.class)), List.of(target, expr));
    }

    private void tryOpenLambda(JCTree.JCLambda tree) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            JCTree.JCExpression body = (JCTree.JCExpression)tree.getBody();
            Type lambdaReturnType = this.getLambdaReturnType(tree);
            if (lambdaReturnType == this.symtab.voidType) {
                JCTree.JCExpressionStatement exec = this.treeMaker.Exec(body);
                tree.body = this.treeMaker.Block(0L, List.of(exec));
            } else {
                JCTree.JCReturn aReturn = this.treeMaker.Return(body);
                tree.body = this.treeMaker.Block(0L, List.of(aReturn));
            }
        }
    }

    private Type getLambdaReturnType(JCTree.JCLambda lambda) {
        Type descriptorType = this.types.findDescriptorType(lambda.type);
        Type.MethodType methodType = descriptorType.asMethodType();
        return methodType.getReturnType();
    }

    private JCTree.JCVariableDecl getLocalLambdaExpr(JCTree.JCExpression body, ListBuffer<JCTree.JCExpression> args, Type returnType, Type gt) {
        Type.ClassType classType = new Type.ClassType(Type.noType, List.of(gt), this.getClassSymbol(LambdaExpression.class));
        return this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, this.names.fromString(this.getNextLambdaParameter()), classType, this.ownerDeque.peek()), this.treeMaker.App(this.getFactoryMethod(Kind.Lambda, Arrays.asList(Expression.class, ParameterExpression[].class, Class.class)), List.of(body, this.makeArray(ParameterExpression.class, args.toList()), this.treeMaker.ClassLiteral(returnType))));
    }

    private Symbol.MethodSymbol methodInvocationGetMethodSymbol(JCTree.JCMethodInvocation tree) {
        Symbol.MethodSymbol methodSymbol;
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        } else {
            JCTree.JCIdent select = (JCTree.JCIdent)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        }
        return methodSymbol;
    }

    private void checkBody(Expr.BodyType value, LambdaExpressionTree.BodyKind bodyKind, JCTree.JCLambda lambda) {
        if (value == Expr.BodyType.Expr && bodyKind == LambdaExpressionTree.BodyKind.STATEMENT || value == Expr.BodyType.Block && bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            throw new RuntimeException(String.format("\u671f\u671b\u7684lambda\u7c7b\u578b\u4e3a: %s,\u5b9e\u9645\u4e3a: %s\n%s", value == Expr.BodyType.Expr ? "\u8868\u8fbe\u5f0f" : "\u4ee3\u7801\u5757", value == Expr.BodyType.Expr ? "\u4ee3\u7801\u5757" : "\u8868\u8fbe\u5f0f", lambda));
        }
    }

    private Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return this.symtab.intType;
            }
            if (clazz == Byte.TYPE) {
                return this.symtab.byteType;
            }
            if (clazz == Short.TYPE) {
                return this.symtab.shortType;
            }
            if (clazz == Long.TYPE) {
                return this.symtab.longType;
            }
            if (clazz == Boolean.TYPE) {
                return this.symtab.booleanType;
            }
            if (clazz == Character.TYPE) {
                return this.symtab.charType;
            }
            if (clazz == Float.TYPE) {
                return this.symtab.floatType;
            }
            if (clazz == Double.TYPE) {
                return this.symtab.doubleType;
            }
            if (clazz == Void.TYPE) {
                return this.symtab.voidType;
            }
        }
        return this.getClassSymbol(clazz).asType();
    }

    private JCTree.JCFieldAccess getFactoryMethod(Kind methodType, java.util.List<Class<?>> argTypes) {
        ListBuffer<Type> typeListBuffer = new ListBuffer<Type>();
        for (Class<?> as : argTypes) {
            if (as.isArray()) {
                Class<?> componentType = as.getComponentType();
                Type.ArrayType arrayType = this.types.makeArrayType(this.getType(componentType));
                typeListBuffer.append(arrayType);
                continue;
            }
            typeListBuffer.append(this.getType(as));
        }
        return this.getFactoryMethod(methodType, typeListBuffer.toList());
    }

    private JCTree.JCFieldAccess getFactoryMethod(Kind methodType, List<Type> argTypes) {
        Name name = this.names.fromString(methodType.name());
        Symbol.ClassSymbol classSymbol = this.getClassSymbol(Expression.class);
        Symbol.MethodSymbol methodSymbol = null;
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            Symbol.MethodSymbol element;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(element = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name)) continue;
            java.util.List parameters = element.getParameters();
            if (((List)parameters).isEmpty() && argTypes.isEmpty()) {
                methodSymbol = element;
                break;
            }
            if (((List)parameters).size() != argTypes.size()) continue;
            ListBuffer<TypeMirror> vars = new ListBuffer<TypeMirror>();
            for (Symbol.VarSymbol parameter : parameters) {
                vars.append(parameter.asType());
            }
            if (!this.types.isSubtypes(argTypes, vars.toList())) continue;
            methodSymbol = element;
        }
        if (methodSymbol != null) {
            return this.refMakeSelector(this.treeMaker.Ident(classSymbol), methodSymbol);
        }
        throw new RuntimeException(String.format("getFactoryMethod\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", new Object[]{methodType, argTypes}));
    }

    private JCTree.JCFieldAccess refMakeSelector(JCTree.JCExpression base, Symbol sym) {
        return (JCTree.JCFieldAccess)ReflectUtil.invokeMethod(this.treeMaker, "Select", Arrays.asList(base, sym));
    }

    private JCTree.JCFieldAccess getOperator(JCTree.Tag tag) {
        return this.getOperator(tag.name());
    }

    private JCTree.JCFieldAccess getOperator(OperatorType operatorType) {
        return this.getOperator(operatorType.name());
    }

    private JCTree.JCFieldAccess getOperator(String op) {
        Symbol.ClassSymbol classSymbol = this.getClassSymbol(OperatorType.class);
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            if (enclosedElement.getKind() != ElementKind.ENUM_CONSTANT || !op.equals(enclosedElement.getSimpleName().toString())) continue;
            return this.refMakeSelector(this.treeMaker.Ident(classSymbol), enclosedElement);
        }
        throw new RuntimeException("getOperator " + classSymbol);
    }

    private Symbol.ClassSymbol getClassSymbol(Class<?> clazz) {
        Name name = this.names.fromString(clazz.getName());
        Symbol.ClassSymbol classSymbol = JDK.is9orLater() ? (Symbol.ClassSymbol)ReflectUtil.invokeMethod(this.symtab, "enterClass", Arrays.asList(this.moduleSymbol, name)) : this.classReader.enterClass(name);
        return classSymbol;
    }

    private Symbol.MethodSymbol getMethodSymbol(Class<?> clazz, String methodName, java.util.List<Class<?>> args) {
        Name name = this.names.fromString(methodName);
        ListBuffer<Type> argTypes = new ListBuffer<Type>();
        for (Class<?> as : args) {
            if (as.isArray()) {
                Class<?> componentType = as.getComponentType();
                Type.ArrayType arrayType = this.types.makeArrayType(this.getType(componentType));
                argTypes.append(arrayType);
                continue;
            }
            argTypes.append(this.getType(as));
        }
        for (Symbol enclosedElement : this.getClassSymbol(clazz).getEnclosedElements()) {
            Symbol.MethodSymbol methodSymbol;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name) || ((List)methodSymbol.getParameters()).size() != argTypes.size()) continue;
            java.util.List parameters = methodSymbol.getParameters();
            ListBuffer<Type> vars = new ListBuffer<Type>();
            for (Symbol.VarSymbol parameter : parameters) {
                TypeMirror type = parameter.asType();
                vars.append(this.types.erasure((Type)type));
            }
            if (!this.types.isSubtypes(argTypes.toList(), vars.toList())) continue;
            return methodSymbol;
        }
        throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", clazz, methodName, args));
    }

    private JCTree.JCMethodInvocation reflectMethod(Type type, String name, ListBuffer<JCTree.JCExpression> args) {
        return this.reflectMethod(type, name, args.toList());
    }

    private JCTree.JCMethodInvocation reflectMethod(Type type, String name, List<JCTree.JCExpression> args) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getMethod", Arrays.asList(Class.class, String.class, Class[].class))), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name), this.makeArray(Class.class, args)));
    }

    private JCTree.JCMethodInvocation reflectField(Type type, String name) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getField", Arrays.asList(Class.class, String.class))), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name)));
    }

    private JCTree.JCNewArray makeArray(Class<?> clazz, List<JCTree.JCExpression> args) {
        JCTree.JCNewArray jcNewArray = this.treeMaker.NewArray(this.treeMaker.Ident(this.getClassSymbol(clazz)), List.nil(), args);
        jcNewArray.setType(this.types.makeArrayType(this.getType(clazz)));
        return jcNewArray;
    }

    private JCTree.JCVariableDecl getLocalVar(Type type, String name) {
        return this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, this.names.fromString(this.getNextLambdaParameter()), this.getType(ParameterExpression.class), this.ownerDeque.peek()), this.treeMaker.App(this.getFactoryMethod(Kind.Parameter, Arrays.asList(Class.class, String.class)), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name))));
    }

    private String getNextLambdaParameter() {
        return "lambdaParameter_" + this.argIndex.getAndIncrement();
    }

    private JCTree.JCLiteral getNull() {
        return this.treeMaker.Literal(TypeTag.BOT, null).setType(this.symtab.botType);
    }

    private JCTree.JCMethodInvocation reflectConstructor(Type type, ListBuffer<JCTree.JCExpression> args) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getConstructor", Arrays.asList(Class.class, Class[].class))), List.of(this.treeMaker.ClassLiteral(type), this.makeArray(Class.class, args.toList())));
    }

    private Symbol.MethodSymbol getMethodSymbol(Symbol classSymbol, Name methodName, Type.MethodType methodType) {
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            Symbol.MethodSymbol methodSymbol;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodName)) continue;
            TypeMirror methodSymbolType = methodSymbol.asType();
            List<Type> parameterTypes1 = ((Type)methodSymbolType).getParameterTypes();
            java.util.List parameterTypes2 = methodType.getParameterTypes();
            if (!this.types.isSubtypes((List<Type>)parameterTypes2, this.types.erasure(parameterTypes1))) continue;
            return methodSymbol;
        }
        throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u51fd\u6570\u7c7b\u578b:%s\n", classSymbol, methodName, methodType));
    }

    private boolean typesEqual(java.util.List<Type> left, java.util.List<Type> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            Type leftType = left.get(i);
            Type rightType = right.get(i);
            if (leftType.toString().equals(rightType.toString())) continue;
            return false;
        }
        return true;
    }

    private Symbol.MethodSymbol getTargetMethodSymbol(Symbol.MethodSymbol methodSymbol, ListBuffer<Type> argsType) {
        Symbol location = methodSymbol.location();
        for (Symbol enclosedElement : location.getEnclosedElements()) {
            Object parameter2;
            Symbol.MethodSymbol element;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(element = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodSymbol.getSimpleName()) || ((List)element.getParameters()).size() != ((List)methodSymbol.getParameters()).size()) continue;
            ArrayList<Type> varTypes = new ArrayList<Type>();
            for (Object parameter2 : element.getParameters()) {
                varTypes.add(this.types.erasure((Type)((Symbol.VarSymbol)parameter2).asType()));
            }
            ArrayList<Type> argTypes = new ArrayList<Type>();
            parameter2 = argsType.iterator();
            while (parameter2.hasNext()) {
                Type type = (Type)parameter2.next();
                argTypes.add(this.types.erasure(type));
            }
            boolean subtypes = this.typesEqual(varTypes, argTypes);
            if (!subtypes) continue;
            return element;
        }
        throw new RuntimeException();
    }

    private void trySetMethodSymbol(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol methodSymbol) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        tree.setType(methodSymbol.getReturnType());
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)methodSelect;
            tree.meth = this.refMakeSelector(select.getExpression(), methodSymbol);
        } else {
            JCTree.JCIdent select = (JCTree.JCIdent)methodSelect;
            tree.meth = this.treeMaker.Ident(methodSymbol);
        }
    }
}

