/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.plugin;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import io.github.kiryu1223.expressionTree.delegate.Delegate;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.annos.Expr;
import io.github.kiryu1223.expressionTree.util.JDK;
import io.github.kiryu1223.expressionTree.util.ReflectUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeMirror;

public class LambdaTreeScanner
extends TreeTranslator {
    private final TreeMaker treeMaker;
    private final Types types;
    private final Names names;
    private final Symtab symtab;
    private final ClassReader classReader;
    private final Object moduleSymbol;
    private final ArrayDeque<Symbol> thizDeque = new ArrayDeque();
    private final ArrayDeque<Symbol> ownerDeque = new ArrayDeque();
    private final ArrayDeque<Symbol.VarSymbol> varSymbolDeque = new ArrayDeque();
    private final ArrayDeque<ListBuffer<JCTree.JCStatement>> statementsDeque = new ArrayDeque();
    private int parameterIndex = 0;
    private final Map<Name, JCTree.JCVariableDecl> lambdaVarMap = new HashMap<Name, JCTree.JCVariableDecl>();
    private final Map<JCTree.JCLambda, JCTree.JCVariableDecl> lambdaCache = new HashMap<JCTree.JCLambda, JCTree.JCVariableDecl>();

    public LambdaTreeScanner(TreeMaker treeMaker, Types types, Names names, Symtab symtab, ClassReader classReader, Object moduleSymbol) {
        this.treeMaker = treeMaker;
        this.types = types;
        this.names = names;
        this.symtab = symtab;
        this.classReader = classReader;
        this.moduleSymbol = moduleSymbol;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.thizDeque.push(tree.sym);
        super.visitClassDef(tree);
        this.thizDeque.pop();
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this.ownerDeque.push(tree.sym);
        super.visitMethodDef(tree);
        this.ownerDeque.pop();
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        if (!tree.isStatic() && !this.ownerDeque.isEmpty()) {
            ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
            this.statementsDeque.push(statements);
            for (JCTree.JCStatement stat : tree.stats) {
                statements.add(this.translate(stat));
            }
            this.statementsDeque.pop();
            tree.stats = statements.toList();
            this.result = tree;
        } else {
            super.visitBlock(tree);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        Symbol.MethodSymbol methodSymbol = this.methodInvocationGetMethodSymbol(tree);
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        java.util.List jcExpressions = tree.getArguments();
        tree.meth = this.translate(tree.getMethodSelect());
        for (int i = 0; i < ((List)jcExpressions).size(); ++i) {
            this.varSymbolDeque.push((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get(i));
            JCTree.JCExpression arg = (JCTree.JCExpression)((List)jcExpressions).get(i);
            args.add(this.translate(arg));
            this.varSymbolDeque.pop();
        }
        tree.args = args.toList();
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        Symbol.VarSymbol varSymbol = this.varSymbolDeque.peek();
        if (varSymbol == null) {
            this.tryBoxLambda(tree);
            super.visitLambda(tree);
            return;
        }
        Expr expr = varSymbol.getAnnotation(Expr.class);
        if (expr == null) {
            this.tryBoxLambda(tree);
            super.visitLambda(tree);
            return;
        }
        this.checkBody(expr.value(), tree.getBodyKind(), tree);
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<Name> nameList = new ListBuffer<Name>();
        ListBuffer<JCTree.JCStatement> peek = this.statementsDeque.peek();
        for (JCTree.JCVariableDecl param : tree.params) {
            JCTree.JCVariableDecl localVar = this.getLocalVar(param.type, param.getName().toString());
            args.append(this.treeMaker.Ident(localVar));
            this.lambdaVarMap.put(param.name, localVar);
            nameList.add(param.name);
            peek.add(localVar);
        }
        JCTree.JCExpression expression = this.deepMake(tree.getBody());
        Type.MethodType methodType = (Type.MethodType)this.types.findDescriptorType(tree.type);
        Type returnType = methodType.getReturnType();
        JCTree.JCVariableDecl localLambdaExpr = this.getLocalLambdaExpr(expression, args, returnType, tree.type);
        peek.add(localLambdaExpr);
        this.lambdaCache.put(tree, localLambdaExpr);
        JCTree.JCExpression ident = this.treeMaker.Ident(localLambdaExpr);
        Symbol.MethodSymbol exprSymbol = this.getMethodSymbol(ExprTree.class, "Expr", Arrays.asList(Delegate.class, LambdaExpression.class));
        JCTree.JCFieldAccess fa = this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ExprTree.class)), exprSymbol);
        JCTree.JCMethodInvocation apply = this.treeMaker.App(fa, List.of(tree, ident));
        this.result = apply;
        for (Name name : nameList) {
            this.lambdaVarMap.remove(name);
        }
    }

    private void tryBoxLambda(JCTree.JCLambda tree) {
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            JCTree.JCExpression body = (JCTree.JCExpression)tree.getBody();
            Type lambdaReturnType = this.getLambdaReturnType(tree);
            if (lambdaReturnType == this.symtab.voidType) {
                JCTree.JCExpressionStatement exec = this.treeMaker.Exec(body);
                tree.body = this.treeMaker.Block(0L, List.of(exec));
            } else {
                JCTree.JCReturn aReturn = this.treeMaker.Return(body);
                tree.body = this.treeMaker.Block(0L, List.of(aReturn));
            }
        }
    }

    private Type getLambdaReturnType(JCTree.JCLambda lambda) {
        Type descriptorType = this.types.findDescriptorType(lambda.type);
        Type.MethodType methodType = descriptorType.asMethodType();
        return methodType.getReturnType();
    }

    private JCTree.JCVariableDecl getLocalLambdaExpr(JCTree.JCExpression body, ListBuffer<JCTree.JCExpression> args, Type returnType, Type gt) {
        Type type = returnType;
        Type.ClassType classType = new Type.ClassType(Type.noType, List.of(gt), this.getClassSymbol(LambdaExpression.class));
        return this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, this.names.fromString(this.getNextLambdaParameter()), classType, this.ownerDeque.peek()), this.treeMaker.App(this.getFactoryMethod(Kind.Lambda, Arrays.asList(Expression.class, ParameterExpression[].class, Class.class)), List.of(body, this.makeArray(ParameterExpression.class, args.toList()), this.treeMaker.ClassLiteral(type))));
    }

    private Symbol.MethodSymbol methodInvocationGetMethodSymbol(JCTree.JCMethodInvocation tree) {
        Symbol.MethodSymbol methodSymbol;
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess select = (JCTree.JCFieldAccess)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        } else {
            JCTree.JCIdent select = (JCTree.JCIdent)methodSelect;
            methodSymbol = (Symbol.MethodSymbol)select.sym;
        }
        return methodSymbol;
    }

    private void checkBody(Expr.BodyType value, LambdaExpressionTree.BodyKind bodyKind, JCTree.JCLambda lambda) {
        if (value == Expr.BodyType.Expr && bodyKind == LambdaExpressionTree.BodyKind.STATEMENT || value == Expr.BodyType.Block && bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            throw new RuntimeException(String.format("\u671f\u671b\u7684lambda\u7c7b\u578b\u4e3a: %s,\u5b9e\u9645\u4e3a: %s\n%s", value == Expr.BodyType.Expr ? "\u8868\u8fbe\u5f0f" : "\u4ee3\u7801\u5757", value == Expr.BodyType.Expr ? "\u4ee3\u7801\u5757" : "\u8868\u8fbe\u5f0f", lambda));
        }
    }

    private Type getType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return this.symtab.intType;
            }
            if (clazz == Byte.TYPE) {
                return this.symtab.byteType;
            }
            if (clazz == Short.TYPE) {
                return this.symtab.shortType;
            }
            if (clazz == Long.TYPE) {
                return this.symtab.longType;
            }
            if (clazz == Boolean.TYPE) {
                return this.symtab.booleanType;
            }
            if (clazz == Character.TYPE) {
                return this.symtab.charType;
            }
            if (clazz == Float.TYPE) {
                return this.symtab.floatType;
            }
            if (clazz == Double.TYPE) {
                return this.symtab.doubleType;
            }
            if (clazz == Void.TYPE) {
                return this.symtab.voidType;
            }
        }
        return this.getClassSymbol(clazz).asType();
    }

    private JCTree.JCFieldAccess getFactoryMethod(Kind methodType, java.util.List<Class<?>> argTypes) {
        ListBuffer<Type> typeListBuffer = new ListBuffer<Type>();
        for (Class<?> as : argTypes) {
            if (as.isArray()) {
                Class<?> componentType = as.getComponentType();
                Type.ArrayType arrayType = this.types.makeArrayType(this.getType(componentType));
                typeListBuffer.append(arrayType);
                continue;
            }
            typeListBuffer.append(this.getType(as));
        }
        return this.getFactoryMethod(methodType, typeListBuffer.toList());
    }

    private JCTree.JCFieldAccess getFactoryMethod(Kind methodType, List<Type> argTypes) {
        Name name = this.names.fromString(methodType.name());
        Symbol.ClassSymbol classSymbol = this.getClassSymbol(Expression.class);
        Symbol.MethodSymbol methodSymbol = null;
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            Symbol.MethodSymbol element;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(element = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name)) continue;
            java.util.List parameters = element.getParameters();
            if (((List)parameters).isEmpty() && argTypes.isEmpty()) {
                methodSymbol = element;
                break;
            }
            if (((List)parameters).size() != argTypes.size()) continue;
            ListBuffer<TypeMirror> vars = new ListBuffer<TypeMirror>();
            for (Symbol.VarSymbol parameter : parameters) {
                vars.append(parameter.asType());
            }
            if (!this.types.isSubtypes(argTypes, vars.toList())) continue;
            methodSymbol = element;
        }
        if (methodSymbol != null) {
            return this.refMakeSelector(this.treeMaker.Ident(classSymbol), methodSymbol);
        }
        throw new RuntimeException(String.format("getFactoryMethod\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", new Object[]{methodType, argTypes}));
    }

    private JCTree.JCFieldAccess refMakeSelector(JCTree.JCExpression base, Symbol sym) {
        return (JCTree.JCFieldAccess)ReflectUtil.invokeMethod(this.treeMaker, "Select", Arrays.asList(base, sym));
    }

    private JCTree.JCFieldAccess getOperator(JCTree.Tag tag) {
        return this.getOperator(tag.name());
    }

    private JCTree.JCFieldAccess getOperator(OperatorType operatorType) {
        return this.getOperator(operatorType.name());
    }

    private JCTree.JCFieldAccess getOperator(String op) {
        Symbol.ClassSymbol classSymbol = this.getClassSymbol(OperatorType.class);
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            if (enclosedElement.getKind() != ElementKind.ENUM_CONSTANT || !op.equals(enclosedElement.getSimpleName().toString())) continue;
            return this.refMakeSelector(this.treeMaker.Ident(classSymbol), enclosedElement);
        }
        throw new RuntimeException("getOperator " + classSymbol);
    }

    private Symbol.ClassSymbol getClassSymbol(Class<?> clazz) {
        Name name = this.names.fromString(clazz.getName());
        Symbol.ClassSymbol classSymbol = JDK.is17orLater() ? (Symbol.ClassSymbol)ReflectUtil.invokeMethod(this.symtab, "enterClass", Arrays.asList(this.moduleSymbol, name)) : (JDK.is9orLater() ? (Symbol.ClassSymbol)ReflectUtil.invokeMethod(this.symtab, "enterClass", Arrays.asList(this.moduleSymbol, name)) : this.classReader.enterClass(name));
        return classSymbol;
    }

    private Symbol.MethodSymbol getMethodSymbol(Class<?> clazz, String methodName, java.util.List<Class<?>> args) {
        Name name = this.names.fromString(methodName);
        ListBuffer<Type> argTypes = new ListBuffer<Type>();
        for (Class<?> as : args) {
            if (as.isArray()) {
                Class<?> componentType = as.getComponentType();
                Type.ArrayType arrayType = this.types.makeArrayType(this.getType(componentType));
                argTypes.append(arrayType);
                continue;
            }
            argTypes.append(this.getType(as));
        }
        for (Symbol enclosedElement : this.getClassSymbol(clazz).getEnclosedElements()) {
            Symbol.MethodSymbol methodSymbol;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name) || ((List)methodSymbol.getParameters()).size() != argTypes.size()) continue;
            java.util.List parameters = methodSymbol.getParameters();
            ListBuffer<Type> vars = new ListBuffer<Type>();
            for (Symbol.VarSymbol parameter : parameters) {
                TypeMirror type = parameter.asType();
                vars.append(this.types.erasure((Type)type));
            }
            if (!this.types.isSubtypes(argTypes.toList(), vars.toList())) continue;
            return methodSymbol;
        }
        throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", clazz, methodName, args));
    }

    private JCTree.JCMethodInvocation reflectMethod(Type type, String name, ListBuffer<JCTree.JCExpression> args) {
        return this.reflectMethod(type, name, args.toList());
    }

    private JCTree.JCMethodInvocation reflectMethod(Type type, String name, List<JCTree.JCExpression> args) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getMethod", Arrays.asList(Class.class, String.class, Class[].class))), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name), this.makeArray(Class.class, args)));
    }

    private JCTree.JCMethodInvocation reflectField(Type type, String name) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getField", Arrays.asList(Class.class, String.class))), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name)));
    }

    private JCTree.JCNewArray makeArray(Class<?> clazz, List<JCTree.JCExpression> args) {
        return (JCTree.JCNewArray)this.treeMaker.NewArray(this.treeMaker.Ident(this.getClassSymbol(clazz)), List.nil(), args).setType(this.types.makeArrayType(this.getType(clazz)));
    }

    private JCTree.JCVariableDecl getLocalVar(Type type, String name) {
        return this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, this.names.fromString(this.getNextLambdaParameter()), this.getType(ParameterExpression.class), this.ownerDeque.peek()), this.treeMaker.App(this.getFactoryMethod(Kind.Parameter, Arrays.asList(Class.class, String.class)), List.of(this.treeMaker.ClassLiteral(type), this.treeMaker.Literal(name))));
    }

    private String getNextLambdaParameter() {
        return "lambdaParameter_" + this.parameterIndex++;
    }

    private JCTree.JCLiteral getNull() {
        return this.treeMaker.Literal(TypeTag.BOT, null).setType(this.symtab.botType);
    }

    private JCTree.JCMethodInvocation reflectConstructor(Type type, ListBuffer<JCTree.JCExpression> args) {
        return this.treeMaker.App(this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getConstructor", Arrays.asList(Class.class, Class[].class))), List.of(this.treeMaker.ClassLiteral(type), this.makeArray(Class.class, args.toList())));
    }

    private Symbol.MethodSymbol getMethodSymbol(Symbol classSymbol, Name methodName, Type.MethodType methodType) {
        for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
            Symbol.MethodSymbol methodSymbol;
            if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodName)) continue;
            TypeMirror methodSymbolType = methodSymbol.asType();
            List<Type> parameterTypes1 = ((Type)methodSymbolType).getParameterTypes();
            java.util.List parameterTypes2 = methodType.getParameterTypes();
            if (!this.types.isSubtypes((List<Type>)parameterTypes2, this.types.erasure(parameterTypes1))) continue;
            return methodSymbol;
        }
        throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u51fd\u6570\u7c7b\u578b:%s\n", classSymbol, methodName, methodType));
    }

    private JCTree.JCExpression deepMake(JCTree tree) {
        if (tree instanceof JCTree.JCPrimitiveTypeTree) {
            JCTree.JCPrimitiveTypeTree jcPrimitiveTypeTree = (JCTree.JCPrimitiveTypeTree)tree;
            return this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(jcPrimitiveTypeTree.type)));
        }
        if (tree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral jcLiteral = (JCTree.JCLiteral)tree;
            return this.treeMaker.App(this.getFactoryMethod(Kind.Constant, Collections.singletonList(Object.class)), List.of(jcLiteral));
        }
        if (tree instanceof JCTree.JCIdent) {
            JCTree.JCIdent jcIdent = (JCTree.JCIdent)tree;
            if (jcIdent.sym.getKind().isClass() || jcIdent.sym.getKind().isInterface()) {
                return this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(jcIdent.type)));
            }
            if (this.lambdaVarMap.containsKey(jcIdent.getName())) {
                JCTree.JCVariableDecl jcVariableDecl = this.lambdaVarMap.get(jcIdent.getName());
                return this.treeMaker.Ident(jcVariableDecl);
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(jcIdent, this.treeMaker.Literal(jcIdent.getName().toString())));
        }
        if (tree instanceof JCTree.JCBinary) {
            JCTree.JCBinary jcBinary = (JCTree.JCBinary)tree;
            JCTree.JCExpression left = this.deepMake(jcBinary.getLeftOperand());
            JCTree.JCExpression right = this.deepMake(jcBinary.getRightOperand());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Binary, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(jcBinary.getTag())));
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            Symbol symbol;
            JCTree.JCExpression select;
            JCTree.JCMethodInvocation jcMethodInvocation = (JCTree.JCMethodInvocation)tree;
            JCTree.JCExpression methodSelect = jcMethodInvocation.getMethodSelect();
            java.util.List arguments = jcMethodInvocation.getArguments();
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            ListBuffer<JCTree.JCExpression> newArgs = new ListBuffer<JCTree.JCExpression>();
            Symbol.MethodSymbol methodInvocationGetMethodSymbol = this.methodInvocationGetMethodSymbol(jcMethodInvocation);
            java.util.List parameters = methodInvocationGetMethodSymbol.getParameters();
            for (int i = 0; i < ((List)arguments).size(); ++i) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((List)parameters).get(i);
                this.varSymbolDeque.push(varSymbol);
                JCTree.JCExpression argument = (JCTree.JCExpression)((List)arguments).get(i);
                JCTree.JCExpression jcExpression = this.deepMake(argument);
                args.append(jcExpression);
                if (argument instanceof JCTree.JCLambda && this.lambdaCache.containsKey(argument)) {
                    JCTree.JCLambda jcLambda = (JCTree.JCLambda)argument;
                    Symbol.MethodSymbol exprSymbol = this.getMethodSymbol(ExprTree.class, "Expr", Arrays.asList(Delegate.class, LambdaExpression.class));
                    JCTree.JCFieldAccess fa = this.refMakeSelector(this.treeMaker.Ident(this.getClassSymbol(ExprTree.class)), exprSymbol);
                    JCTree.JCMethodInvocation apply = this.treeMaker.App(fa, List.of(jcLambda, jcExpression));
                    newArgs.add(apply);
                } else {
                    newArgs.add(argument);
                }
                this.varSymbolDeque.pop();
            }
            jcMethodInvocation.args = newArgs.toList();
            java.util.List<Class<?>> argTypes = Arrays.asList(Expression.class, Method.class, Expression[].class);
            ListBuffer<JCTree.JCExpression> of = new ListBuffer<JCTree.JCExpression>();
            if (methodSelect instanceof JCTree.JCIdent) {
                select = (JCTree.JCIdent)methodSelect;
                symbol = ((JCTree.JCIdent)select).sym.location();
                Symbol.MethodSymbol methodSymbol = this.getMethodSymbol(symbol, this.names.fromString(((JCTree.JCIdent)select).getName().toString()), methodSelect.type.asMethodType());
                if (methodSymbol.isStatic()) {
                    of.append(this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(symbol.asType()))));
                } else {
                    of.append(this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(this.treeMaker.This(this.thizDeque.peek().type), this.treeMaker.Literal("this"))));
                }
            } else {
                select = (JCTree.JCFieldAccess)methodSelect;
                symbol = ((JCTree.JCFieldAccess)select).sym.location();
                of.append(this.deepMake(((JCTree.JCFieldAccess)select).getExpression()));
            }
            String methodName = methodSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)methodSelect).getIdentifier().toString() : methodSelect.toString();
            ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
            for (Type parameterType : methodSelect.type.asMethodType().getParameterTypes()) {
                ts.add(this.treeMaker.ClassLiteral(parameterType));
            }
            of.append(this.reflectMethod(symbol.asType(), methodName, ts)).append((JCTree.JCMethodInvocation)((Object)this.makeArray(Expression.class, args.toList())));
            return this.treeMaker.App(this.getFactoryMethod(Kind.MethodCall, argTypes), of.toList());
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)tree;
            if (jcFieldAccess.sym.getKind() == ElementKind.FIELD && jcFieldAccess.getIdentifier().toString().equals("class")) {
                return this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(this.treeMaker.ClassLiteral(jcFieldAccess.getExpression().type)));
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.FieldSelect, Arrays.asList(Expression.class, Field.class)), List.of(this.deepMake(jcFieldAccess.getExpression()), this.reflectField(jcFieldAccess.getExpression().type, jcFieldAccess.getIdentifier().toString())));
        }
        if (tree instanceof JCTree.JCParens) {
            JCTree.JCParens jcParens = (JCTree.JCParens)tree;
            JCTree.JCExpression expr = this.deepMake(jcParens.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Parens, Collections.singletonList(Expression.class)), List.of(expr));
        }
        if (tree instanceof JCTree.JCBlock) {
            JCTree.JCBlock jcBlock = (JCTree.JCBlock)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            ListBuffer<Name> locals = new ListBuffer<Name>();
            for (JCTree.JCStatement statement : jcBlock.getStatements()) {
                if (statement instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)statement;
                    JCTree.JCVariableDecl localVar = this.getLocalVar(jcVariableDecl.type, jcVariableDecl.getName().toString());
                    locals.add(jcVariableDecl.getName());
                    this.lambdaVarMap.put(jcVariableDecl.getName(), localVar);
                    this.statementsDeque.peek().add(localVar);
                }
                args.append(this.deepMake(statement));
            }
            for (Name local : locals) {
                this.lambdaVarMap.remove(local);
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Block, Arrays.asList(Expression[].class, Boolean.TYPE)), List.of(this.makeArray(Expression.class, args.toList()), this.treeMaker.Literal(jcBlock.isStatic())));
        }
        if (tree instanceof JCTree.JCExpressionStatement) {
            JCTree.JCExpressionStatement jcExpressionStatement = (JCTree.JCExpressionStatement)tree;
            return this.deepMake(jcExpressionStatement.getExpression());
        }
        if (tree instanceof JCTree.JCUnary) {
            JCTree.JCUnary jcUnary = (JCTree.JCUnary)tree;
            JCTree.JCExpression expr = this.deepMake(jcUnary.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Unary, Arrays.asList(Expression.class, OperatorType.class)), List.of(expr, this.getOperator(jcUnary.getTag())));
        }
        if (tree instanceof JCTree.JCAssign) {
            JCTree.JCAssign jcAssign = (JCTree.JCAssign)tree;
            JCTree.JCExpression left = this.deepMake(jcAssign.getVariable());
            JCTree.JCExpression right = this.deepMake(jcAssign.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Assign, Arrays.asList(Expression.class, Expression.class)), List.of(left, right));
        }
        if (tree instanceof JCTree.JCAssignOp) {
            JCTree.JCAssignOp jcAssignOp = (JCTree.JCAssignOp)tree;
            JCTree.JCExpression left = this.deepMake(jcAssignOp.getVariable());
            JCTree.JCExpression right = this.deepMake(jcAssignOp.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.AssignOp, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(jcAssignOp.getTag())));
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(this.treeMaker.Ident(this.lambdaVarMap.get(jcVariableDecl.getName())));
            if (jcVariableDecl.getInitializer() != null) {
                args.append(this.deepMake(jcVariableDecl.getInitializer()));
            } else {
                args.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Variable, Arrays.asList(ParameterExpression.class, Expression.class)), args.toList());
        }
        if (tree instanceof JCTree.JCArrayAccess) {
            JCTree.JCArrayAccess jcArrayAccess = (JCTree.JCArrayAccess)tree;
            JCTree.JCExpression indexed = this.deepMake(jcArrayAccess.getExpression());
            JCTree.JCExpression index = this.deepMake(jcArrayAccess.getIndex());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Index, Arrays.asList(Expression.class, Expression.class)), List.of(indexed, index));
        }
        if (tree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)tree;
            ArrayList classes = new ArrayList(4);
            ListBuffer<JCTree.JCExpression> all = new ListBuffer<JCTree.JCExpression>();
            classes.add(Class.class);
            all.append(this.treeMaker.ClassLiteral(jcNewClass.type));
            ListBuffer<JCTree.JCExpression> typeArgs = new ListBuffer<JCTree.JCExpression>();
            if (jcNewClass.getIdentifier() instanceof JCTree.JCTypeApply) {
                JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)jcNewClass.getIdentifier();
                for (Object typeArgument : typeApply.getTypeArguments()) {
                    typeArgs.append(this.treeMaker.ClassLiteral(((JCTree.JCExpression)typeArgument).type));
                }
            }
            classes.add(Class[].class);
            all.append(this.makeArray(Class.class, typeArgs.toList()));
            classes.add(Constructor.class);
            Symbol.MethodSymbol init = (Symbol.MethodSymbol)jcNewClass.constructor;
            ListBuffer<JCTree.JCExpression> types = new ListBuffer<JCTree.JCExpression>();
            for (Object parameter : init.getParameters()) {
                types.add(this.treeMaker.ClassLiteral((Type)((Symbol.VarSymbol)parameter).asType()));
            }
            all.append(this.reflectConstructor(jcNewClass.type, types));
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCExpression argument : jcNewClass.getArguments()) {
                args.append(this.deepMake(argument));
            }
            classes.add(Expression[].class);
            all.append(this.makeArray(Expression.class, args.toList()));
            JCTree.JCClassDecl classBody = jcNewClass.getClassBody();
            classes.add(BlockExpression.class);
            if (classBody != null) {
                ListBuffer<JCTree.JCExpression> body = new ListBuffer<JCTree.JCExpression>();
                for (JCTree member : classBody.getMembers()) {
                    if (!(member instanceof JCTree.JCVariableDecl)) continue;
                    JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)member;
                    JCTree.JCExpression variable = this.deepMake(variableDecl);
                    body.add(variable);
                }
                all.append(this.treeMaker.App(this.getFactoryMethod(Kind.Block, Collections.singletonList(Expression[].class)), List.of(this.makeArray(Expression.class, body.toList()))));
            } else {
                all.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.New, classes), all.toList());
        }
        if (tree instanceof JCTree.JCNewArray) {
            JCTree.JCNewArray jcNewArray = (JCTree.JCNewArray)tree;
            ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCExpression dimension : jcNewArray.getDimensions()) {
                dims.append(this.deepMake(dimension));
            }
            for (JCTree.JCExpression initializer : jcNewArray.getInitializers()) {
                args.append(this.deepMake(initializer));
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.NewArray, Arrays.asList(Class.class, Expression[].class, Expression[].class)), List.of(this.treeMaker.ClassLiteral(jcNewArray.getType().type), this.makeArray(Expression.class, dims.toList()), this.makeArray(Expression.class, args.toList())));
        }
        if (tree instanceof JCTree.JCReturn) {
            JCTree.JCReturn jcReturn = (JCTree.JCReturn)tree;
            JCTree.JCExpression result = this.deepMake(jcReturn.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Return, Collections.singletonList(Expression.class)), List.of(result));
        }
        if (tree instanceof JCTree.JCBreak) {
            return this.treeMaker.App(this.getFactoryMethod(Kind.Break, Collections.emptyList()));
        }
        if (tree instanceof JCTree.JCContinue) {
            return this.treeMaker.App(this.getFactoryMethod(Kind.Continue, Collections.emptyList()));
        }
        if (tree instanceof JCTree.JCConditional) {
            JCTree.JCConditional jcConditional = (JCTree.JCConditional)tree;
            JCTree.JCExpression cond = this.deepMake(jcConditional.getCondition());
            JCTree.JCExpression ifTrue = this.deepMake(jcConditional.getTrueExpression());
            JCTree.JCExpression ifFalse = this.deepMake(jcConditional.getFalseExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Conditional, Arrays.asList(Expression.class, Expression.class, Expression.class)), List.of(cond, ifTrue, ifFalse));
        }
        if (tree instanceof JCTree.JCIf) {
            JCTree.JCIf jcIf = (JCTree.JCIf)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            JCTree.JCExpression cond = this.deepMake(jcIf.getCondition());
            args.append(cond);
            if (jcIf.getThenStatement() != null) {
                JCTree.JCExpression then = this.deepMake(jcIf.getThenStatement());
                args.append(then);
            } else {
                args.append(this.getNull());
            }
            if (jcIf.getElseStatement() != null) {
                JCTree.JCExpression elSe = this.deepMake(jcIf.getElseStatement());
                args.append(elSe);
            } else {
                args.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.If, Arrays.asList(Expression.class, Expression.class, Expression.class)), args.toList());
        }
        if (tree instanceof JCTree.JCForLoop) {
            JCTree.JCForLoop jcForLoop = (JCTree.JCForLoop)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            ListBuffer<JCTree.JCExpression> inits = new ListBuffer<JCTree.JCExpression>();
            for (Object jcStatement : jcForLoop.getInitializer()) {
                inits.append(this.deepMake((JCTree)jcStatement));
            }
            args.append(this.makeArray(Expression.class, inits.toList()));
            if (jcForLoop.getCondition() != null) {
                args.append(this.deepMake(jcForLoop.getCondition()));
            } else {
                args.append(this.getNull());
            }
            ListBuffer<JCTree.JCExpression> steps = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCExpressionStatement expressionStatement : jcForLoop.getUpdate()) {
                steps.append(this.deepMake(expressionStatement));
            }
            args.append(this.makeArray(Expression.class, steps.toList()));
            if (jcForLoop.getStatement() != null) {
                args.append(this.deepMake(jcForLoop.getStatement()));
            } else {
                args.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.For, Arrays.asList(Expression[].class, Expression.class, Expression[].class, Expression.class)), args.toList());
        }
        if (tree instanceof JCTree.JCEnhancedForLoop) {
            JCTree.JCEnhancedForLoop jcEnhancedForLoop = (JCTree.JCEnhancedForLoop)tree;
            JCTree.JCExpression var = this.deepMake(jcEnhancedForLoop.getVariable());
            JCTree.JCExpression expr = this.deepMake(jcEnhancedForLoop.getExpression());
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(var).append(expr);
            if (jcEnhancedForLoop.getStatement() != null) {
                args.append(this.deepMake(jcEnhancedForLoop.getStatement()));
            } else {
                args.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Foreach, Arrays.asList(VariableExpression.class, Expression.class, Expression.class)), args.toList());
        }
        if (tree instanceof JCTree.JCWhileLoop) {
            JCTree.JCWhileLoop jcWhileLoop = (JCTree.JCWhileLoop)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(this.deepMake(jcWhileLoop.getCondition()));
            if (jcWhileLoop.getStatement() != null) {
                args.append(this.deepMake(jcWhileLoop.getStatement()));
            } else {
                args.append(this.getNull());
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.While, Arrays.asList(Expression.class, Expression.class)), args.toList());
        }
        if (tree instanceof JCTree.JCSwitch) {
            JCTree.JCSwitch jcSwitch = (JCTree.JCSwitch)tree;
            JCTree.JCExpression selector = this.deepMake(jcSwitch.getExpression());
            ListBuffer<JCTree.JCExpression> cases = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCCase aCase : jcSwitch.getCases()) {
                cases.append(this.deepMake(aCase));
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Switch, Arrays.asList(Expression.class, CaseExpression[].class)), List.of(selector, this.makeArray(CaseExpression.class, cases.toList())));
        }
        if (tree instanceof JCTree.JCCase) {
            JCTree.JCCase jcCase = (JCTree.JCCase)tree;
            JCTree.JCExpression part = this.deepMake(jcCase.getExpression());
            ListBuffer<JCTree.JCExpression> stats = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCStatement statement : jcCase.getStatements()) {
                stats.append(this.deepMake(statement));
            }
            return this.treeMaker.App(this.getFactoryMethod(Kind.Case, Arrays.asList(Expression.class, Expression[].class)), List.of(part, this.makeArray(Expression.class, stats.toList())));
        }
        if (tree instanceof JCTree.JCTry) {
            JCTree.JCTry jcTry = (JCTree.JCTry)tree;
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(this.deepMake(jcTry.getBlock()));
            ListBuffer<JCTree.JCExpression> catches = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCCatch aCatch : jcTry.getCatches()) {
                catches.append(this.deepMake(aCatch));
            }
            args.append(this.makeArray(CatchExpression.class, catches.toList()));
            if (jcTry.getFinallyBlock() != null) {
                args.append(this.deepMake(jcTry.getFinallyBlock()));
            } else {
                args.append(this.getNull());
            }
            ListBuffer<JCTree.JCExpression> resources = new ListBuffer<JCTree.JCExpression>();
            for (JCTree resource : jcTry.getResources()) {
                resources.append(this.deepMake(resource));
            }
            args.append(this.makeArray(Expression.class, resources.toList()));
            return this.treeMaker.App(this.getFactoryMethod(Kind.Try, Arrays.asList(BlockExpression.class, CatchExpression[].class, BlockExpression.class, Expression[].class)), args.toList());
        }
        if (tree instanceof JCTree.JCCatch) {
            JCTree.JCCatch jcCatch = (JCTree.JCCatch)tree;
            JCTree.JCExpression param = this.deepMake(jcCatch.getParameter());
            JCTree.JCExpression body = this.deepMake(jcCatch.getBlock());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Catch, Arrays.asList(VariableExpression.class, BlockExpression.class)), List.of(param, body));
        }
        if (tree instanceof JCTree.JCThrow) {
            JCTree.JCThrow jcThrow = (JCTree.JCThrow)tree;
            JCTree.JCExpression expr = this.deepMake(jcThrow.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.Throw, Collections.singletonList(Expression.class)), List.of(expr));
        }
        if (tree instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast jcTypeCast = (JCTree.JCTypeCast)tree;
            JCTree.JCExpression target = this.deepMake(jcTypeCast.getType());
            JCTree.JCExpression expr = this.deepMake(jcTypeCast.getExpression());
            return this.treeMaker.App(this.getFactoryMethod(Kind.TypeCast, Arrays.asList(Class.class, Expression.class)), List.of(target, expr));
        }
        if (tree instanceof JCTree.JCLambda) {
            JCTree.JCLambda lambda = (JCTree.JCLambda)tree;
            this.visitLambda(lambda);
            JCTree.JCVariableDecl jcVariableDecl = this.lambdaCache.get(lambda);
            JCTree.JCExpression ident = this.treeMaker.Ident(jcVariableDecl);
            return ident;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + tree.type + "\n" + tree);
    }
}

