/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.plugin;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import io.github.kiryu1223.expressionTree.delegate.Delegate;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.CaseExpression;
import io.github.kiryu1223.expressionTree.expressions.CatchExpression;
import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.annos.Expr;
import io.github.kiryu1223.expressionTree.util.JDK;
import io.github.kiryu1223.expressionTree.util.ReflectUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class SugarScannerV2
extends TreeScanner {
    private Symbol thiz;
    private Symbol owner;
    private ListBuffer<JCTree.JCStatement> newStatement;
    private static long index = 0L;
    private final TreeMaker treeMaker;
    private final Types types;
    private final Names names;
    private final Symtab symtab;
    private final ClassReader classReader;
    private final Object moduleSymbol;

    public SugarScannerV2(TreeMaker treeMaker, Types types, Names names, Symtab symtab, ClassReader classReader, Object moduleSymbol) {
        this.treeMaker = treeMaker;
        this.types = types;
        this.names = names;
        this.symtab = symtab;
        this.classReader = classReader;
        this.moduleSymbol = moduleSymbol;
    }

    public static void resetIndex() {
        index = 0L;
    }

    public void setThiz(Symbol thiz) {
        this.thiz = thiz;
    }

    public void setOwner(Symbol owner) {
        this.owner = owner;
    }

    public void setNewStatement(ListBuffer<JCTree.JCStatement> newStatement) {
        this.newStatement = newStatement;
    }

    private boolean hasTaskMake(JCTree.JCBlock block) {
        java.util.List statements = block.getStatements();
        if (((List)statements).isEmpty()) {
            return false;
        }
        JCTree.JCStatement jcStatement = (JCTree.JCStatement)((List)statements).get(0);
        if (!(jcStatement instanceof JCTree.JCVariableDecl)) {
            return false;
        }
        JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)jcStatement;
        return variableDecl.getName().toString().equals("taskMake") || variableDecl.getType() instanceof JCTree.JCPrimitiveTypeTree && ((JCTree.JCPrimitiveTypeTree)variableDecl.getType()).getPrimitiveTypeKind() == TypeKind.INT;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl classDecl) {
        this.thiz = classDecl.sym;
        super.visitClassDef(classDecl);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl methodDecl) {
        this.owner = methodDecl.sym;
        super.visitMethodDef(methodDecl);
    }

    @Override
    public void visitBlock(JCTree.JCBlock block) {
        if (!block.isStatic()) {
            if (this.owner != null) {
                this.joinBlock(block);
                this.owner = null;
            } else {
                if (!this.hasTaskMake(block)) {
                    return;
                }
                JCTree.JCVariableDecl first = (JCTree.JCVariableDecl)((List)block.getStatements()).get(0);
                this.owner = first.sym.location();
                this.joinBlock(block);
                this.owner = null;
            }
        } else {
            if (!this.hasTaskMake(block)) {
                return;
            }
            JCTree.JCVariableDecl first = (JCTree.JCVariableDecl)((List)block.getStatements()).get(0);
            this.owner = first.sym.location();
            this.joinBlock(block);
            this.owner = null;
        }
    }

    private void joinBlock(JCTree.JCBlock block) {
        this.newStatement = new ListBuffer();
        for (JCTree.JCStatement statement : block.getStatements()) {
            SugarScannerV2 sugarScannerV2 = new SugarScannerV2(this.treeMaker, this.types, this.names, this.symtab, this.classReader, this.moduleSymbol);
            sugarScannerV2.setThiz(this.thiz);
            sugarScannerV2.setOwner(this.owner);
            sugarScannerV2.setNewStatement(this.newStatement);
            statement.accept(sugarScannerV2);
            this.newStatement.append(statement);
        }
        block.stats = this.newStatement.toList();
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation invocation) {
        invocation.accept(new SugarTranslator(this.newStatement, this.owner));
    }

    private Symbol.ClassSymbol getClassSymbol(Class<?> clazz) {
        Symbol.ClassSymbol classSymbol;
        Name name = this.names.fromString(clazz.getName());
        if (JDK.is17orLater()) {
            classSymbol = (Symbol.ClassSymbol)ReflectUtil.invokeMethod(this.symtab, "enterClass", Arrays.asList(this.moduleSymbol, name));
        } else if (JDK.is9orLater()) {
            classSymbol = (Symbol.ClassSymbol)ReflectUtil.invokeMethod(this.symtab, "enterClass", Arrays.asList(this.moduleSymbol, name));
        } else {
            classSymbol = (Symbol.ClassSymbol)((Map)ReflectUtil.getFieldValue(this.symtab, "classes")).get(name);
            if (classSymbol == null) {
                classSymbol = this.classReader.enterClass(name);
            }
        }
        return classSymbol;
    }

    private class SugarTranslator
    extends TreeScanner {
        private final ListBuffer<JCTree.JCStatement> jcStatements;
        private final Map<Name, JCTree.JCVariableDecl> variableDeclMap = new HashMap<Name, JCTree.JCVariableDecl>();
        private final Map<Name, JCTree.JCVariableDecl> tempVariableDeclMap = new HashMap<Name, JCTree.JCVariableDecl>();
        private final Map<JCTree.JCLambda, JCTree.JCVariableDecl> tempLambdaMap = new HashMap<JCTree.JCLambda, JCTree.JCVariableDecl>();
        private final Symbol owner;

        public SugarTranslator(ListBuffer<JCTree.JCStatement> jcStatements, Symbol owner) {
            this.jcStatements = jcStatements;
            this.owner = owner;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation invocation) {
            super.visitApply(invocation);
            JCTree.JCExpression methodSelect = invocation.getMethodSelect();
            java.util.List arguments = invocation.getArguments();
            if (!((List)arguments).isEmpty()) {
                Symbol symbol;
                JCTree.JCExpression select;
                boolean flag = false;
                if (methodSelect instanceof JCTree.JCFieldAccess) {
                    select = (JCTree.JCFieldAccess)methodSelect;
                    symbol = select.sym;
                } else {
                    select = (JCTree.JCIdent)methodSelect;
                    symbol = ((JCTree.JCIdent)select).sym;
                }
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                for (int i = 0; i < ((List)arguments).size(); ++i) {
                    JCTree.JCExpression jcExpression = (JCTree.JCExpression)((List)arguments).get(i);
                    if (jcExpression.getKind() != Tree.Kind.LAMBDA_EXPRESSION || !this.checkExprAnno((Symbol.MethodSymbol)symbol, i, ((JCTree.JCLambda)jcExpression).getBodyKind())) {
                        args.append(jcExpression);
                        continue;
                    }
                    JCTree.JCLambda lambda = (JCTree.JCLambda)jcExpression;
                    flag = true;
                    JCTree.JCExpression built = this.buildExpr(lambda);
                    Symbol.MethodSymbol expr = this.getMethodSymbol(ExprTree.class, "Expr", Arrays.asList(Delegate.class, LambdaExpression.class));
                    JCTree.JCFieldAccess fa = this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(SugarScannerV2.this.getClassSymbol(ExprTree.class)), expr);
                    JCTree.JCMethodInvocation apply = SugarScannerV2.this.treeMaker.App(fa, List.of(jcExpression, built));
                    args.append(apply);
                }
                if (flag) {
                    Symbol.MethodSymbol methodSymbol = this.getMethodSymbol((Symbol)((Symbol.ClassSymbol)symbol.location()), methodSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)methodSelect).getIdentifier() : ((JCTree.JCIdent)methodSelect).getName(), args.toList());
                    JCTree.JCMethodInvocation methodInvocationRes = SugarScannerV2.this.treeMaker.App(methodSelect instanceof JCTree.JCFieldAccess ? this.refMakeSelector(((JCTree.JCFieldAccess)methodSelect).getExpression(), methodSymbol) : SugarScannerV2.this.treeMaker.Ident(methodSymbol), args.toList());
                    invocation.typeargs = methodInvocationRes.typeargs;
                    invocation.meth = methodInvocationRes.meth;
                    invocation.args = methodInvocationRes.args;
                }
            }
        }

        private String getNextLambdaParameter() {
            return "lambdaParameter_" + index++;
        }

        private JCTree.JCVariableDecl getLocalVar(Type type, String name) {
            return SugarScannerV2.this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, SugarScannerV2.this.names.fromString(this.getNextLambdaParameter()), this.getType(ParameterExpression.class), this.owner), SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Parameter, Arrays.asList(Class.class, String.class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(type), SugarScannerV2.this.treeMaker.Literal(name))));
        }

        private JCTree.JCVariableDecl getLocalLambdaExpr(JCTree.JCExpression body, ListBuffer<JCTree.JCExpression> args, Type returnType, Type gt) {
            Type type = returnType;
            Type.ClassType classType = new Type.ClassType(Type.noType, List.of(gt), SugarScannerV2.this.getClassSymbol(LambdaExpression.class));
            return SugarScannerV2.this.treeMaker.VarDef(new Symbol.VarSymbol(0x20000040000L, SugarScannerV2.this.names.fromString(this.getNextLambdaParameter()), classType, this.owner), SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Lambda, Arrays.asList(Expression.class, ParameterExpression[].class, Class.class)), List.of(body, this.makeArray(ParameterExpression.class, args.toList()), SugarScannerV2.this.treeMaker.ClassLiteral(type))));
        }

        private JCTree.JCExpression buildExpr(JCTree.JCLambda lambda) {
            return this.deepMake(lambda);
        }

        /*
         * WARNING - void declaration
         */
        private JCTree.JCExpression deepMake(JCTree tree) {
            if (tree instanceof JCTree.JCPrimitiveTypeTree) {
                JCTree.JCPrimitiveTypeTree jcPrimitiveTypeTree = (JCTree.JCPrimitiveTypeTree)tree;
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(jcPrimitiveTypeTree.type)));
            }
            if (tree instanceof JCTree.JCLiteral) {
                JCTree.JCLiteral jcLiteral = (JCTree.JCLiteral)tree;
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Constant, Collections.singletonList(Object.class)), List.of(jcLiteral));
            }
            if (tree instanceof JCTree.JCIdent) {
                JCTree.JCIdent jcIdent = (JCTree.JCIdent)tree;
                if (jcIdent.sym.getKind().isClass() || jcIdent.sym.getKind().isInterface()) {
                    return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(jcIdent.type)));
                }
                if (this.variableDeclMap.containsKey(jcIdent.getName())) {
                    return SugarScannerV2.this.treeMaker.Ident(this.variableDeclMap.get(jcIdent.getName()));
                }
                if (this.tempVariableDeclMap.containsKey(jcIdent.getName())) {
                    return SugarScannerV2.this.treeMaker.Ident(this.tempVariableDeclMap.get(jcIdent.getName()));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(jcIdent, SugarScannerV2.this.treeMaker.Literal(jcIdent.getName().toString())));
            }
            if (tree instanceof JCTree.JCBinary) {
                JCTree.JCBinary jcBinary = (JCTree.JCBinary)tree;
                JCTree.JCExpression left = this.deepMake(jcBinary.getLeftOperand());
                JCTree.JCExpression right = this.deepMake(jcBinary.getRightOperand());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Binary, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(jcBinary.getTag())));
            }
            if (tree instanceof JCTree.JCMethodInvocation) {
                void var8_102;
                JCTree.JCExpression select;
                JCTree.JCMethodInvocation jcMethodInvocation = (JCTree.JCMethodInvocation)tree;
                JCTree.JCExpression methodSelect = jcMethodInvocation.getMethodSelect();
                java.util.List arguments = jcMethodInvocation.getArguments();
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCExpression argument : arguments) {
                    if (argument instanceof JCTree.JCMethodInvocation && ((List)((JCTree.JCMethodInvocation)argument).getArguments()).size() == 2 && ((JCTree.JCExpression)((List)((JCTree.JCMethodInvocation)argument).getArguments()).get(0)).getKind() == Tree.Kind.LAMBDA_EXPRESSION && argument.type.tsym.equals(SugarScannerV2.this.getClassSymbol(ExprTree.class))) {
                        JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)argument;
                        JCTree.JCLambda lambda = (JCTree.JCLambda)((List)jCMethodInvocation.getArguments()).get(0);
                        JCTree.JCVariableDecl variableDecl = this.tempLambdaMap.get(lambda);
                        JCTree.JCExpression ag = SugarScannerV2.this.treeMaker.Ident(variableDecl);
                        args.append(ag);
                        continue;
                    }
                    args.append(this.deepMake(argument));
                }
                ArrayList argTypes = new ArrayList(Arrays.asList(Expression.class, Method.class, Expression[].class));
                ListBuffer<JCTree.JCExpression> of = new ListBuffer<JCTree.JCExpression>();
                if (methodSelect instanceof JCTree.JCIdent) {
                    select = (JCTree.JCIdent)methodSelect;
                    Symbol symbol = ((JCTree.JCIdent)select).sym.location();
                    Symbol.MethodSymbol methodSymbol = this.getMethodSymbol(symbol, SugarScannerV2.this.names.fromString(((JCTree.JCIdent)select).getName().toString()), methodSelect.type.asMethodType());
                    if (methodSymbol.isStatic()) {
                        of.append(SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(symbol.asType()))));
                    } else {
                        of.append(SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Reference, Arrays.asList(Object.class, String.class)), List.of(SugarScannerV2.this.treeMaker.This(((SugarScannerV2)SugarScannerV2.this).thiz.type), SugarScannerV2.this.treeMaker.Literal("this"))));
                    }
                } else {
                    select = (JCTree.JCFieldAccess)methodSelect;
                    Symbol symbol = ((JCTree.JCFieldAccess)select).sym.location();
                    of.append(this.deepMake(((JCTree.JCFieldAccess)select).getExpression()));
                }
                Type.MethodType methodType = methodSelect.type.asMethodType();
                String methodName = methodSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)methodSelect).getIdentifier().toString() : methodSelect.toString();
                ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
                for (Type parameterType : methodSelect.type.asMethodType().getParameterTypes()) {
                    ts.add(SugarScannerV2.this.treeMaker.ClassLiteral(parameterType));
                }
                of.append(this.reflectMethod(var8_102.asType(), methodName, ts)).append((JCTree.JCMethodInvocation)((Object)this.makeArray(Expression.class, args.toList())));
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.MethodCall, argTypes), of.toList());
            }
            if (tree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)tree;
                if (jcFieldAccess.sym.getKind() == ElementKind.FIELD && jcFieldAccess.getIdentifier().toString().equals("class")) {
                    return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.StaticClass, Collections.singletonList(Class.class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(jcFieldAccess.getExpression().type)));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.FieldSelect, Arrays.asList(Expression.class, Field.class)), List.of(this.deepMake(jcFieldAccess.getExpression()), this.reflectField(jcFieldAccess.getExpression().type, jcFieldAccess.getIdentifier().toString())));
            }
            if (tree instanceof JCTree.JCParens) {
                JCTree.JCParens jcParens = (JCTree.JCParens)tree;
                JCTree.JCExpression expr = this.deepMake(jcParens.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Parens, Collections.singletonList(Expression.class)), List.of(expr));
            }
            if (tree instanceof JCTree.JCBlock) {
                JCTree.JCBlock jcBlock = (JCTree.JCBlock)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCStatement statement : jcBlock.getStatements()) {
                    args.append(this.deepMake(statement));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Block, Arrays.asList(Expression[].class, Boolean.TYPE)), List.of(this.makeArray(Expression.class, args.toList()), SugarScannerV2.this.treeMaker.Literal(jcBlock.isStatic())));
            }
            if (tree instanceof JCTree.JCExpressionStatement) {
                JCTree.JCExpressionStatement jcExpressionStatement = (JCTree.JCExpressionStatement)tree;
                return this.deepMake(jcExpressionStatement.getExpression());
            }
            if (tree instanceof JCTree.JCUnary) {
                JCTree.JCUnary jcUnary = (JCTree.JCUnary)tree;
                JCTree.JCExpression expr = this.deepMake(jcUnary.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Unary, Arrays.asList(Expression.class, OperatorType.class)), List.of(expr, this.getOperator(jcUnary.getTag())));
            }
            if (tree instanceof JCTree.JCAssign) {
                JCTree.JCAssign jcAssign = (JCTree.JCAssign)tree;
                JCTree.JCExpression left = this.deepMake(jcAssign.getVariable());
                JCTree.JCExpression right = this.deepMake(jcAssign.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Assign, Arrays.asList(Expression.class, Expression.class)), List.of(left, right));
            }
            if (tree instanceof JCTree.JCAssignOp) {
                JCTree.JCAssignOp jcAssignOp = (JCTree.JCAssignOp)tree;
                JCTree.JCExpression left = this.deepMake(jcAssignOp.getVariable());
                JCTree.JCExpression right = this.deepMake(jcAssignOp.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.AssignOp, Arrays.asList(Expression.class, Expression.class, OperatorType.class)), List.of(left, right, this.getOperator(jcAssignOp.getTag())));
            }
            if (tree instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                JCTree.JCVariableDecl localVar = this.getLocalVar(jcVariableDecl.type, jcVariableDecl.getName().toString());
                this.jcStatements.append(localVar);
                this.tempVariableDeclMap.put(jcVariableDecl.getName(), localVar);
                args.append(SugarScannerV2.this.treeMaker.Ident(localVar));
                if (jcVariableDecl.getInitializer() != null) {
                    args.append(this.deepMake(jcVariableDecl.getInitializer()));
                } else {
                    args.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Variable, Arrays.asList(ParameterExpression.class, Expression.class)), args.toList());
            }
            if (tree instanceof JCTree.JCArrayAccess) {
                JCTree.JCArrayAccess jcArrayAccess = (JCTree.JCArrayAccess)tree;
                JCTree.JCExpression indexed = this.deepMake(jcArrayAccess.getExpression());
                JCTree.JCExpression index = this.deepMake(jcArrayAccess.getIndex());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Index, Arrays.asList(Expression.class, Expression.class)), List.of(indexed, index));
            }
            if (tree instanceof JCTree.JCNewClass) {
                JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)tree;
                ArrayList classes = new ArrayList(4);
                ListBuffer<JCTree.JCExpression> all = new ListBuffer<JCTree.JCExpression>();
                classes.add(Class.class);
                all.append(SugarScannerV2.this.treeMaker.ClassLiteral(jcNewClass.type));
                ListBuffer<JCTree.JCExpression> typeArgs = new ListBuffer<JCTree.JCExpression>();
                if (jcNewClass.getIdentifier() instanceof JCTree.JCTypeApply) {
                    JCTree.JCTypeApply typeApply = (JCTree.JCTypeApply)jcNewClass.getIdentifier();
                    for (JCTree.JCExpression jCExpression : typeApply.getTypeArguments()) {
                        typeArgs.append(SugarScannerV2.this.treeMaker.ClassLiteral(jCExpression.type));
                    }
                }
                classes.add(Class[].class);
                all.append(this.makeArray(Class.class, typeArgs.toList()));
                classes.add(Constructor.class);
                Symbol.MethodSymbol init = (Symbol.MethodSymbol)jcNewClass.constructor;
                ListBuffer<JCTree.JCExpression> types = new ListBuffer<JCTree.JCExpression>();
                for (Object parameter : init.getParameters()) {
                    types.add(SugarScannerV2.this.treeMaker.ClassLiteral((Type)((Symbol.VarSymbol)parameter).asType()));
                }
                all.append(this.reflectConstructor(jcNewClass.type, types));
                ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCExpression argument : jcNewClass.getArguments()) {
                    listBuffer.append(this.deepMake(argument));
                }
                classes.add(Expression[].class);
                all.append(this.makeArray(Expression.class, listBuffer.toList()));
                JCTree.JCClassDecl classBody = jcNewClass.getClassBody();
                classes.add(BlockExpression.class);
                if (classBody != null) {
                    ListBuffer<JCTree.JCExpression> body = new ListBuffer<JCTree.JCExpression>();
                    for (JCTree member : classBody.getMembers()) {
                        if (!(member instanceof JCTree.JCVariableDecl)) continue;
                        JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)member;
                        JCTree.JCExpression variable = this.deepMake(variableDecl);
                        body.add(variable);
                    }
                    all.append(SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Block, Collections.singletonList(Expression[].class)), List.of(this.makeArray(Expression.class, body.toList()))));
                } else {
                    all.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.New, classes), all.toList());
            }
            if (tree instanceof JCTree.JCNewArray) {
                JCTree.JCNewArray jcNewArray = (JCTree.JCNewArray)tree;
                ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCExpression dimension : jcNewArray.getDimensions()) {
                    dims.append(this.deepMake(dimension));
                }
                for (JCTree.JCExpression initializer : jcNewArray.getInitializers()) {
                    args.append(this.deepMake(initializer));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.NewArray, Arrays.asList(Class.class, Expression[].class, Expression[].class)), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(jcNewArray.getType().type), this.makeArray(Expression.class, dims.toList()), this.makeArray(Expression.class, args.toList())));
            }
            if (tree instanceof JCTree.JCReturn) {
                JCTree.JCReturn jcReturn = (JCTree.JCReturn)tree;
                JCTree.JCExpression result = this.deepMake(jcReturn.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Return, Collections.singletonList(Expression.class)), List.of(result));
            }
            if (tree instanceof JCTree.JCBreak) {
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Break, Collections.emptyList()));
            }
            if (tree instanceof JCTree.JCContinue) {
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Continue, Collections.emptyList()));
            }
            if (tree instanceof JCTree.JCConditional) {
                JCTree.JCConditional jcConditional = (JCTree.JCConditional)tree;
                JCTree.JCExpression cond = this.deepMake(jcConditional.getCondition());
                JCTree.JCExpression ifTrue = this.deepMake(jcConditional.getTrueExpression());
                JCTree.JCExpression ifFalse = this.deepMake(jcConditional.getFalseExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Conditional, Arrays.asList(Expression.class, Expression.class, Expression.class)), List.of(cond, ifTrue, ifFalse));
            }
            if (tree instanceof JCTree.JCIf) {
                JCTree.JCIf jcIf = (JCTree.JCIf)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                JCTree.JCExpression cond = this.deepMake(jcIf.getCondition());
                args.append(cond);
                if (jcIf.getThenStatement() != null) {
                    JCTree.JCExpression then = this.deepMake(jcIf.getThenStatement());
                    args.append(then);
                } else {
                    args.append(this.getNull());
                }
                if (jcIf.getElseStatement() != null) {
                    JCTree.JCExpression elSe = this.deepMake(jcIf.getElseStatement());
                    args.append(elSe);
                } else {
                    args.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.If, Arrays.asList(Expression.class, Expression.class, Expression.class)), args.toList());
            }
            if (tree instanceof JCTree.JCForLoop) {
                JCTree.JCForLoop jcForLoop = (JCTree.JCForLoop)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                ListBuffer<JCTree.JCExpression> inits = new ListBuffer<JCTree.JCExpression>();
                for (Object jcStatement : jcForLoop.getInitializer()) {
                    inits.append(this.deepMake((JCTree)jcStatement));
                }
                args.append(this.makeArray(Expression.class, inits.toList()));
                if (jcForLoop.getCondition() != null) {
                    args.append(this.deepMake(jcForLoop.getCondition()));
                } else {
                    args.append(this.getNull());
                }
                ListBuffer<JCTree.JCExpression> steps = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCExpressionStatement expressionStatement : jcForLoop.getUpdate()) {
                    steps.append(this.deepMake(expressionStatement));
                }
                args.append(this.makeArray(Expression.class, steps.toList()));
                if (jcForLoop.getStatement() != null) {
                    args.append(this.deepMake(jcForLoop.getStatement()));
                } else {
                    args.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.For, Arrays.asList(Expression[].class, Expression.class, Expression[].class, Expression.class)), args.toList());
            }
            if (tree instanceof JCTree.JCEnhancedForLoop) {
                JCTree.JCEnhancedForLoop jcEnhancedForLoop = (JCTree.JCEnhancedForLoop)tree;
                JCTree.JCExpression var = this.deepMake(jcEnhancedForLoop.getVariable());
                JCTree.JCExpression expr = this.deepMake(jcEnhancedForLoop.getExpression());
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                args.append(var).append(expr);
                if (jcEnhancedForLoop.getStatement() != null) {
                    args.append(this.deepMake(jcEnhancedForLoop.getStatement()));
                } else {
                    args.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Foreach, Arrays.asList(VariableExpression.class, Expression.class, Expression.class)), args.toList());
            }
            if (tree instanceof JCTree.JCWhileLoop) {
                JCTree.JCWhileLoop jcWhileLoop = (JCTree.JCWhileLoop)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                args.append(this.deepMake(jcWhileLoop.getCondition()));
                if (jcWhileLoop.getStatement() != null) {
                    args.append(this.deepMake(jcWhileLoop.getStatement()));
                } else {
                    args.append(this.getNull());
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.While, Arrays.asList(Expression.class, Expression.class)), args.toList());
            }
            if (tree instanceof JCTree.JCSwitch) {
                JCTree.JCSwitch jcSwitch = (JCTree.JCSwitch)tree;
                JCTree.JCExpression selector = this.deepMake(jcSwitch.getExpression());
                ListBuffer<JCTree.JCExpression> cases = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCCase aCase : jcSwitch.getCases()) {
                    cases.append(this.deepMake(aCase));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Switch, Arrays.asList(Expression.class, CaseExpression[].class)), List.of(selector, this.makeArray(CaseExpression.class, cases.toList())));
            }
            if (tree instanceof JCTree.JCCase) {
                JCTree.JCCase jcCase = (JCTree.JCCase)tree;
                JCTree.JCExpression part = this.deepMake(jcCase.getExpression());
                ListBuffer<JCTree.JCExpression> stats = new ListBuffer<JCTree.JCExpression>();
                for (JCTree.JCStatement statement : jcCase.getStatements()) {
                    stats.append(this.deepMake(statement));
                }
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Case, Arrays.asList(Expression.class, Expression[].class)), List.of(part, this.makeArray(Expression.class, stats.toList())));
            }
            if (tree instanceof JCTree.JCTry) {
                JCTree.JCTry jcTry = (JCTree.JCTry)tree;
                ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                args.append(this.deepMake(jcTry.getBlock()));
                ListBuffer<JCTree.JCExpression> catches = new ListBuffer<JCTree.JCExpression>();
                for (Object aCatch : jcTry.getCatches()) {
                    catches.append(this.deepMake((JCTree)aCatch));
                }
                args.append(this.makeArray(CatchExpression.class, catches.toList()));
                if (jcTry.getFinallyBlock() != null) {
                    args.append(this.deepMake(jcTry.getFinallyBlock()));
                } else {
                    args.append(this.getNull());
                }
                ListBuffer<JCTree.JCExpression> resources = new ListBuffer<JCTree.JCExpression>();
                for (JCTree resource : jcTry.getResources()) {
                    resources.append(this.deepMake(resource));
                }
                args.append(this.makeArray(Expression.class, resources.toList()));
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Try, Arrays.asList(BlockExpression.class, CatchExpression[].class, BlockExpression.class, Expression[].class)), args.toList());
            }
            if (tree instanceof JCTree.JCCatch) {
                JCTree.JCCatch jcCatch = (JCTree.JCCatch)tree;
                JCTree.JCExpression param = this.deepMake(jcCatch.getParameter());
                JCTree.JCExpression body = this.deepMake(jcCatch.getBlock());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Catch, Arrays.asList(VariableExpression.class, BlockExpression.class)), List.of(param, body));
            }
            if (tree instanceof JCTree.JCThrow) {
                JCTree.JCThrow jcThrow = (JCTree.JCThrow)tree;
                JCTree.JCExpression expr = this.deepMake(jcThrow.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.Throw, Collections.singletonList(Expression.class)), List.of(expr));
            }
            if (tree instanceof JCTree.JCTypeCast) {
                JCTree.JCTypeCast jcTypeCast = (JCTree.JCTypeCast)tree;
                JCTree.JCExpression target = this.deepMake(jcTypeCast.getType());
                JCTree.JCExpression expr = this.deepMake(jcTypeCast.getExpression());
                return SugarScannerV2.this.treeMaker.App(this.getFactoryMethod(Kind.TypeCast, Arrays.asList(Class.class, Expression.class)), List.of(target, expr));
            }
            if (tree instanceof JCTree.JCLambda) {
                JCTree.JCVariableDecl localLambdaExpr;
                JCTree.JCLambda lambda = (JCTree.JCLambda)tree;
                if (this.tempLambdaMap.containsKey(lambda)) {
                    localLambdaExpr = this.tempLambdaMap.get(lambda);
                } else {
                    Type.MethodType methodType = (Type.MethodType)SugarScannerV2.this.types.findDescriptorType(lambda.type);
                    Type returnType = methodType.getReturnType();
                    ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                    for (VariableTree variableTree : lambda.getParameters()) {
                        JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)variableTree;
                        JCTree.JCVariableDecl localVar = this.getLocalVar(jcVariableDecl.type, jcVariableDecl.getName().toString());
                        args.append(SugarScannerV2.this.treeMaker.Ident(localVar));
                        this.variableDeclMap.put(jcVariableDecl.getName(), localVar);
                        this.jcStatements.append(localVar);
                    }
                    JCTree.JCExpression body = this.deepMake(lambda.getBody());
                    localLambdaExpr = this.getLocalLambdaExpr(body, args, returnType, lambda.type);
                    this.jcStatements.append(localLambdaExpr);
                    this.tempLambdaMap.put(lambda, localLambdaExpr);
                }
                return SugarScannerV2.this.treeMaker.Ident(localLambdaExpr);
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + tree.type + "\n" + tree);
        }

        private boolean checkExprAnno(Symbol.MethodSymbol symbol, int index, LambdaExpressionTree.BodyKind bodyKind) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)((List)symbol.getParameters()).get(index);
            Expr expr = varSymbol.getAnnotation(Expr.class);
            if (expr == null) {
                return false;
            }
            Expr.BodyType value = expr.value();
            if (value == Expr.BodyType.Any) {
                return true;
            }
            if (value == Expr.BodyType.Expr && bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION || value == Expr.BodyType.Block && bodyKind == LambdaExpressionTree.BodyKind.STATEMENT) {
                return true;
            }
            throw new RuntimeException(String.format("\u671f\u671b\u7684lambda\u7c7b\u578b\u4e3a: %s,\u5b9e\u9645\u4e3a: %s\n%s", value == Expr.BodyType.Expr ? "\u8868\u8fbe\u5f0f" : "\u4ee3\u7801\u5757", value == Expr.BodyType.Expr ? "\u4ee3\u7801\u5757" : "\u8868\u8fbe\u5f0f", symbol));
        }

        private Symbol.MethodSymbol getMethodSymbol(Class<?> clazz, String methodName, java.util.List<Class<?>> args) {
            Name name = SugarScannerV2.this.names.fromString(methodName);
            ListBuffer<Type> argTypes = new ListBuffer<Type>();
            for (Class<?> as : args) {
                if (as.isArray()) {
                    Class<?> componentType = as.getComponentType();
                    Type.ArrayType arrayType = SugarScannerV2.this.types.makeArrayType(this.getType(componentType));
                    argTypes.append(arrayType);
                    continue;
                }
                argTypes.append(this.getType(as));
            }
            for (Symbol enclosedElement : SugarScannerV2.this.getClassSymbol(clazz).getEnclosedElements()) {
                Symbol.MethodSymbol methodSymbol;
                if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name) || ((List)methodSymbol.getParameters()).size() != argTypes.size()) continue;
                java.util.List parameters = methodSymbol.getParameters();
                ListBuffer<Type> vars = new ListBuffer<Type>();
                for (Symbol.VarSymbol parameter : parameters) {
                    TypeMirror type = parameter.asType();
                    vars.append(SugarScannerV2.this.types.erasure((Type)type));
                }
                if (!SugarScannerV2.this.types.isSubtypes(argTypes.toList(), vars.toList())) continue;
                return methodSymbol;
            }
            throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", clazz, methodName, args));
        }

        private Symbol.MethodSymbol getMethodSymbol(Symbol classSymbol, Name methodName, Type.MethodType methodType) {
            for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
                Symbol.MethodSymbol methodSymbol;
                if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodName)) continue;
                TypeMirror methodSymbolType = methodSymbol.asType();
                List<Type> parameterTypes1 = ((Type)methodSymbolType).getParameterTypes();
                java.util.List parameterTypes2 = methodType.getParameterTypes();
                if (!SugarScannerV2.this.types.isSubtypes((List<Type>)parameterTypes2, SugarScannerV2.this.types.erasure(parameterTypes1))) continue;
                return methodSymbol;
            }
            throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u51fd\u6570\u7c7b\u578b:%s\n", classSymbol, methodName, methodType));
        }

        private Symbol.MethodSymbol getMethodSymbol(Symbol classSymbol, Name methodName, java.util.List<JCTree.JCExpression> args) {
            ListBuffer<Type> argTypes = new ListBuffer<Type>();
            for (JCTree.JCExpression expression : args) {
                argTypes.append(expression.type);
            }
            List typeList = argTypes.toList();
            for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
                Symbol.MethodSymbol methodSymbol;
                if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(methodSymbol = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(methodName)) continue;
                TypeMirror methodSymbolType = methodSymbol.asType();
                List<Type> parameterTypes = ((Type)methodSymbolType).getParameterTypes();
                if (typeList.size() != parameterTypes.size()) continue;
                boolean flag = false;
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    Type parameterType = SugarScannerV2.this.types.erasure(parameterTypes.get(i));
                    Type listType = SugarScannerV2.this.types.erasure((Type)typeList.get(i));
                    if (parameterType.toString().equals(listType.toString())) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                return methodSymbol;
            }
            throw new RuntimeException(String.format("getMethodSymbol\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u76ee\u6807\u7c7b\u4e3a:%s\n \u51fd\u6570\u540d\u4e3a:%s\n \u51fd\u6570\u7c7b\u578b:%s\n", classSymbol, methodName, args));
        }

        private Type getType(Class<?> clazz) {
            if (clazz.isPrimitive()) {
                if (clazz == Integer.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.intType;
                }
                if (clazz == Byte.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.byteType;
                }
                if (clazz == Short.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.shortType;
                }
                if (clazz == Long.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.longType;
                }
                if (clazz == Boolean.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.booleanType;
                }
                if (clazz == Character.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.charType;
                }
                if (clazz == Float.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.floatType;
                }
                if (clazz == Double.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.doubleType;
                }
                if (clazz == Void.TYPE) {
                    return ((SugarScannerV2)SugarScannerV2.this).symtab.voidType;
                }
            }
            return SugarScannerV2.this.getClassSymbol(clazz).asType();
        }

        private JCTree.JCFieldAccess getFactoryMethod(Kind methodType, java.util.List<Class<?>> args) {
            Name name = SugarScannerV2.this.names.fromString(methodType.name());
            ListBuffer<Type> argTypes = new ListBuffer<Type>();
            for (Class<?> as : args) {
                if (as.isArray()) {
                    Class<?> componentType = as.getComponentType();
                    Type.ArrayType arrayType = SugarScannerV2.this.types.makeArrayType(this.getType(componentType));
                    argTypes.append(arrayType);
                    continue;
                }
                argTypes.append(this.getType(as));
            }
            Symbol.ClassSymbol classSymbol = SugarScannerV2.this.getClassSymbol(Expression.class);
            Symbol.MethodSymbol methodSymbol = null;
            for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
                Symbol.MethodSymbol element;
                if (!(enclosedElement instanceof Symbol.MethodSymbol) || !((Object)(element = (Symbol.MethodSymbol)enclosedElement).getSimpleName()).equals(name)) continue;
                java.util.List parameters = element.getParameters();
                if (((List)parameters).isEmpty() && args.isEmpty()) {
                    methodSymbol = element;
                    break;
                }
                if (((List)parameters).size() != args.size()) continue;
                ListBuffer<TypeMirror> vars = new ListBuffer<TypeMirror>();
                for (Symbol.VarSymbol parameter : parameters) {
                    vars.append(parameter.asType());
                }
                if (!SugarScannerV2.this.types.isSubtypes(argTypes.toList(), vars.toList())) continue;
                methodSymbol = element;
            }
            if (methodSymbol != null) {
                return this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(classSymbol), methodSymbol);
            }
            throw new RuntimeException(String.format("getFactoryMethod\u65b9\u6cd5\u65e0\u6cd5\u83b7\u53d6\u5230\u51fd\u6570\n \u51fd\u6570\u540d\u4e3a:%s\n \u53c2\u6570\u7c7b\u578b\u4e3a:%s\n", new Object[]{methodType, args}));
        }

        private JCTree.JCFieldAccess refMakeSelector(JCTree.JCExpression base, Symbol sym) {
            return (JCTree.JCFieldAccess)ReflectUtil.invokeMethod(SugarScannerV2.this.treeMaker, "Select", Arrays.asList(base, sym));
        }

        private JCTree.JCFieldAccess getOperator(JCTree.Tag tag) {
            return this.getOperator(tag.name());
        }

        private JCTree.JCFieldAccess getOperator(OperatorType operatorType) {
            return this.getOperator(operatorType.name());
        }

        private JCTree.JCFieldAccess getOperator(String op) {
            Symbol.ClassSymbol classSymbol = SugarScannerV2.this.getClassSymbol(OperatorType.class);
            for (Symbol enclosedElement : classSymbol.getEnclosedElements()) {
                if (enclosedElement.getKind() != ElementKind.ENUM_CONSTANT || !op.equals(enclosedElement.getSimpleName().toString())) continue;
                return this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(classSymbol), enclosedElement);
            }
            throw new RuntimeException("getOperator " + classSymbol);
        }

        private JCTree.JCNewArray makeArray(Class<?> clazz, List<JCTree.JCExpression> args) {
            return (JCTree.JCNewArray)SugarScannerV2.this.treeMaker.NewArray(SugarScannerV2.this.treeMaker.Ident(SugarScannerV2.this.getClassSymbol(clazz)), List.nil(), args).setType(SugarScannerV2.this.types.makeArrayType(this.getType(clazz)));
        }

        private JCTree.JCMethodInvocation reflectField(Type type, String name) {
            return SugarScannerV2.this.treeMaker.App(this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(SugarScannerV2.this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getField", Arrays.asList(Class.class, String.class))), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(type), SugarScannerV2.this.treeMaker.Literal(name)));
        }

        private JCTree.JCMethodInvocation reflectMethod(Type type, String name, ListBuffer<JCTree.JCExpression> args) {
            return this.reflectMethod(type, name, args.toList());
        }

        private JCTree.JCMethodInvocation reflectMethod(Type type, String name, List<JCTree.JCExpression> args) {
            return SugarScannerV2.this.treeMaker.App(this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(SugarScannerV2.this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getMethod", Arrays.asList(Class.class, String.class, Class[].class))), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(type), SugarScannerV2.this.treeMaker.Literal(name), this.makeArray(Class.class, args)));
        }

        private JCTree.JCMethodInvocation reflectConstructor(Type type, ListBuffer<JCTree.JCExpression> args) {
            return SugarScannerV2.this.treeMaker.App(this.refMakeSelector(SugarScannerV2.this.treeMaker.Ident(SugarScannerV2.this.getClassSymbol(ReflectUtil.class)), this.getMethodSymbol(ReflectUtil.class, "getConstructor", Arrays.asList(Class.class, Class[].class))), List.of(SugarScannerV2.this.treeMaker.ClassLiteral(type), this.makeArray(Class.class, args.toList())));
        }

        private JCTree.JCLiteral getNull() {
            return SugarScannerV2.this.treeMaker.Literal(TypeTag.BOT, null).setType(((SugarScannerV2)SugarScannerV2.this).symtab.botType);
        }
    }
}

