/*
 * Decompiled with CFR 0.152.
 */
package io.github.kiryu1223.expressionTree.util;

import io.github.kiryu1223.expressionTree.expressions.annos.Recode;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectUtil {
    private static final Map<Class<?>, Map<String, Field>> fieldCache = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Map<Class<?>[], Method>>> methodCache = new ConcurrentHashMap();

    public static Field getField(@Recode Class<?> clazz, String name) {
        try {
            Map<String, Field> fieldMap;
            if (!fieldCache.containsKey(clazz)) {
                fieldCache.put(clazz, new ConcurrentHashMap());
            }
            if (!(fieldMap = fieldCache.get(clazz)).containsKey(name)) {
                Field declaredField = clazz.getDeclaredField(name);
                declaredField.setAccessible(true);
                fieldMap.put(name, declaredField);
            }
            return fieldMap.get(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(@Recode Class<?> clazz, String name, Class<?>[] classes) {
        try {
            Map<Class<?>[], Method> methodMap = ReflectUtil.getMethodMap(clazz, name);
            if (!methodMap.containsKey(classes)) {
                Method declaredMethod = clazz.getDeclaredMethod(name, classes);
                declaredMethod.setAccessible(true);
                methodMap.put(classes, declaredMethod);
            }
            return methodMap.get(classes);
        }
        catch (NoSuchMethodException e) {
            for (Method declaredMethod : clazz.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!declaredMethod.getName().equals(name) || declaredMethod.getParameterCount() != classes.length || !ReflectUtil.AllAssignableFrom(parameterTypes = declaredMethod.getParameterTypes(), classes)) continue;
                Map<Class<?>[], Method> methodMap = ReflectUtil.getMethodMap(clazz, name);
                declaredMethod.setAccessible(true);
                methodMap.put(classes, declaredMethod);
                return declaredMethod;
            }
            throw new RuntimeException(e);
        }
    }

    public static Constructor<?> getConstructor(@Recode Class<?> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(parameterTypes);
            declaredConstructor.setAccessible(true);
            return declaredConstructor;
        }
        catch (NoSuchMethodException e) {
            if (clazz.isAnonymousClass()) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    private static Map<Class<?>[], Method> getMethodMap(Class<?> clazz, String name) {
        Map<String, Map<Class<?>[], Method>> nameMethodMap;
        if (!methodCache.containsKey(clazz)) {
            methodCache.put(clazz, new ConcurrentHashMap());
        }
        if (!(nameMethodMap = methodCache.get(clazz)).containsKey(name)) {
            nameMethodMap.put(name, new ConcurrentHashMap());
        }
        return nameMethodMap.get(name);
    }

    private static boolean AllAssignableFrom(Class<?>[] parameterTypes, Class<?>[] classes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!(parameterTypes[i].isPrimitive() || classes[i].isPrimitive() ? !ReflectUtil.specialJudgments(parameterTypes[i], classes[i]) : !parameterTypes[i].isAssignableFrom(classes[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean specialJudgments(Class<?> classA, Class<?> classB) {
        if (classA == classB) {
            return true;
        }
        return !(classA == Long.TYPE || classA == Long.class ? classB != Long.TYPE && classB != Long.class && classB != Integer.TYPE && classB != Integer.class && classB != Short.TYPE && classB != Short.class && classB != Byte.TYPE && classB != Byte.class : (classA == Integer.TYPE || classA == Integer.class ? classB != Integer.TYPE && classB != Integer.class && classB != Short.TYPE && classB != Short.class && classB != Byte.TYPE && classB != Byte.class : (classA == Short.TYPE || classA == Short.class ? classB != Short.TYPE && classB != Short.class && classB != Byte.TYPE && classB != Byte.class : (classA == Byte.TYPE || classA == Byte.class ? classB != Byte.TYPE && classB != Byte.class : (classA == Character.TYPE || classA == Character.class ? classB != Character.TYPE && classB != Character.class : (classA == Boolean.TYPE || classA == Boolean.class ? classB != Boolean.TYPE && classB != Boolean.class : (classA == Double.TYPE || classA == Double.class ? classB != Long.TYPE && classB != Long.class && classB != Integer.TYPE && classB != Integer.class && classB != Short.TYPE && classB != Short.class && classB != Byte.TYPE && classB != Byte.class && classB != Float.TYPE && classB != Float.class && classB != Double.TYPE && classB != Double.class : (classA == Float.TYPE || classA == Float.class) && classB != Long.TYPE && classB != Long.class && classB != Integer.TYPE && classB != Integer.class && classB != Short.TYPE && classB != Short.class && classB != Byte.TYPE && classB != Byte.class && classB != Float.TYPE && classB != Float.class)))))));
    }

    public static <T> T getFieldValue(Object o, String name) {
        try {
            Field field = ReflectUtil.getField(o.getClass(), name);
            field.setAccessible(true);
            return (T)field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeMethod(Object o, String name, List<Object> values) {
        try {
            Method method = ReflectUtil.getMethod(o.getClass(), name, (Class[])values.stream().map(Object::getClass).toArray(Class[]::new));
            method.setAccessible(true);
            return (T)method.invoke(o, values.toArray());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

