/*
 * Decompiled with CFR 0.152.
 */
package blockcanary.ui;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import blockcanary.BlockCanary;
import blockcanary.BlockDetectListener;
import blockcanary.BlockInfo;
import blockcanary.ui.BlockListActivity;
import blockcanary.ui.NotificationType;
import blockcanary.ui.Notifications;
import blockcanary.ui.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lblockcanary/ui/BlockCanaryUI;", "Lblockcanary/BlockDetectListener;", "()V", "application", "Landroid/app/Application;", "onBlockDetected", "", "blockInfo", "Lblockcanary/BlockInfo;", "blockcanary-ui_release"})
public final class BlockCanaryUI
implements BlockDetectListener {
    private static final Application application;
    public static final BlockCanaryUI INSTANCE;

    public void onBlockDetected(@NotNull BlockInfo blockInfo) {
        Intrinsics.checkNotNullParameter((Object)blockInfo, (String)"blockInfo");
        PendingIntent intent = BlockListActivity.Companion.createPendingIntent((Context)application);
        Notifications.INSTANCE.showNotification((Context)application, "\u68c0\u6d4b\u5230\u6162\u6d88\u606f\u5904\u7406", "\u5904\u7406\u8017\u65f6: " + blockInfo.costTime() + " ms", intent, R.id.block_canary_blocking_detected, NotificationType.LEAKCANARY_MAX);
    }

    private BlockCanaryUI() {
    }

    static {
        BlockCanaryUI blockCanaryUI;
        INSTANCE = blockCanaryUI = new BlockCanaryUI();
        application = BlockCanary.INSTANCE.applicationContext();
        BlockCanary.INSTANCE.addBlockDetectListener((BlockDetectListener)blockCanaryUI);
    }
}

