/*
 * Decompiled with CFR 0.152.
 */
package blockcanary.ui;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupMenu;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.Toolbar;
import androidx.appcompat.app.AppCompatActivity;
import blockcanary.BlockCanary;
import blockcanary.BlockInfo;
import blockcanary.CanaryExecutors;
import blockcanary.ui.BlockListActivity;
import blockcanary.ui.HandlersKt;
import blockcanary.ui.R;
import blockcanary.ui.util.SimpleListAdapter;
import blockcanary.ui.util.TimeFormatter;
import com.knightboost.flamegraph.FlameGraphActivity;
import com.knightboost.stacksampler.util.FlameGraphUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0014J\b\u0010\u001d\u001a\u00020\nH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lblockcanary/ui/BlockListActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "toolbar", "Landroid/widget/Toolbar;", "getToolbar", "()Landroid/widget/Toolbar;", "toolbar$delegate", "Lkotlin/Lazy;", "onBlockLongClick", "", "view", "Landroid/view/View;", "blockInfo", "Lblockcanary/BlockInfo;", "onBlocksRetrieved", "blocks", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onResume", "refreshList", "Companion", "blockcanary-ui_release"})
public final class BlockListActivity
extends AppCompatActivity {
    private final Lazy toolbar$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Toolbar>(this){
        final /* synthetic */ BlockListActivity this$0;

        @NotNull
        public final Toolbar invoke() {
            View view = this.this$0.findViewById(R.id.tool_bar);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.tool_bar)");
            return (Toolbar)view;
        }
        {
            this.this$0 = blockListActivity;
            super(0);
        }
    }));
    public static final Companion Companion = new Companion(null);

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_block_list);
    }

    private final Toolbar getToolbar() {
        Lazy lazy = this.toolbar$delegate;
        BlockListActivity blockListActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Toolbar)lazy.getValue();
    }

    protected void onResume() {
        super.onResume();
        this.refreshList();
    }

    public boolean onCreateOptionsMenu(@Nullable Menu menu2) {
        this.getMenuInflater().inflate(R.menu.block_canary_main_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int itemId = item.getItemId();
        if (itemId == R.id.clear_all) {
            BlockCanary.INSTANCE.getBlockInfoRepository().deleteAll();
            this.refreshList();
        }
        return super.onOptionsItemSelected(item);
    }

    private final void refreshList() {
        new Thread(new Runnable(this){
            final /* synthetic */ BlockListActivity this$0;

            public final void run() {
                List blocks = BlockCanary.INSTANCE.getBlockInfoRepository().listBlockInfo();
                HandlersKt.getMainHandler().post(new Runnable(this, blocks){
                    final /* synthetic */ refreshList.1 this$0;
                    final /* synthetic */ List $blocks;

                    public final void run() {
                        this.this$0.this$0.onBlocksRetrieved(this.$blocks);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$blocks = list;
                    }
                });
            }
            {
                this.this$0 = blockListActivity;
            }
        }).start();
    }

    public final void onBlocksRetrieved(@NotNull List<BlockInfo> blocks) {
        ListView listView;
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        ListView listView2 = listView = (ListView)this.findViewById(R.id.block_canary_list);
        Intrinsics.checkNotNullExpressionValue((Object)listView2, (String)"listView");
        listView2.setAdapter((ListAdapter)new SimpleListAdapter<BlockInfo>(R.layout.block_canary_block_row, blocks, (Function3)new Function3<SimpleListAdapter<BlockInfo>, View, Integer, Unit>(this, blocks){
            final /* synthetic */ BlockListActivity this$0;
            final /* synthetic */ List $blocks;

            public final void invoke(@NotNull SimpleListAdapter<BlockInfo> $receiver, @NotNull View view, int position) {
                Intrinsics.checkNotNullParameter($receiver, (String)"$receiver");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                TextView descriptionView = (TextView)view.findViewById(R.id.block_canary_block_text);
                TextView timeView = (TextView)view.findViewById(R.id.block_canary_time_text);
                BlockInfo block = (BlockInfo)this.$blocks.get(position);
                Context context = view.getContext();
                TextView textView = descriptionView;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"descriptionView");
                textView.setText((CharSequence)("\u6d88\u606f\u5904\u7406\u8017\u65f6" + block.costTime() + "ms"));
                Context context2 = context;
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                String formattedDate = TimeFormatter.INSTANCE.formatTimestamp(context2, block.getStartTime());
                TextView textView2 = timeView;
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"timeView");
                textView2.setText((CharSequence)this.this$0.getResources().getString(R.string.block_canary_group_list_time_label, new Object[]{formattedDate}));
                view.setOnClickListener(new View.OnClickListener(context, block){
                    final /* synthetic */ Context $context;
                    final /* synthetic */ BlockInfo $block;

                    public final void onClick(View it) {
                        WeakReference<Context> contextRef = new WeakReference<Context>(this.$context);
                        CanaryExecutors.INSTANCE.getWorkExecutor().execute(new Runnable(this){
                            final /* synthetic */ onBlocksRetrieved.1 this$0;

                            public final void run() {
                                BlockInfo blockDetail = BlockCanary.INSTANCE.getBlockInfoRepository().blockInfoDetail(this.this$0.$block.getStartTime());
                                if (blockDetail == null) {
                                    HandlersKt.getMainHandler().post(new Runnable(this){
                                        final /* synthetic */ onBlocksRetrieved.1 this$0;

                                        public final void run() {
                                            Toast.makeText((Context)this.this$0.this$0.$context, (CharSequence)"file is deleted or broken", (int)0);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                    return;
                                }
                                List stackTraceSamples = blockDetail.getStackTraceSamples();
                                String flameGraphText = FlameGraphUtil.toFlameGraphText((List)stackTraceSamples, (boolean)false);
                                Context context = this.this$0.$context;
                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                                File dir = new File(context.getCacheDir(), "/flameGraph");
                                dir.delete();
                                File file = new File(dir, SystemClock.uptimeMillis() + ".flameGraph");
                                File file2 = file.getParentFile();
                                if (file2 != null) {
                                    file2.mkdirs();
                                }
                                file.createNewFile();
                                String string2 = flameGraphText;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"flameGraphText");
                                FilesKt.writeText$default((File)file, (String)string2, null, (int)2, null);
                                Context context2 = this.this$0.$context;
                                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                                String string3 = file.getAbsolutePath();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.absolutePath");
                                FlameGraphActivity.Companion.start(context2, string3, 50);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.$context = context;
                        this.$block = blockInfo;
                    }
                });
                view.setOnLongClickListener(new View.OnLongClickListener(this, block){
                    final /* synthetic */ onBlocksRetrieved.1 this$0;
                    final /* synthetic */ BlockInfo $block;

                    public final boolean onLongClick(View it) {
                        BlockListActivity blockListActivity = this.this$0.this$0;
                        View view = it;
                        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"it");
                        BlockListActivity.access$onBlockLongClick(blockListActivity, view, this.$block);
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$block = blockInfo;
                    }
                });
            }
            {
                this.this$0 = blockListActivity;
                this.$blocks = list;
                super(3);
            }
        }));
    }

    private final void onBlockLongClick(View view, BlockInfo blockInfo) {
        PopupMenu popupMenu = new PopupMenu((Context)this, view, 85);
        popupMenu.getMenuInflater().inflate(R.menu.block_item_action, popupMenu.getMenu());
        popupMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(this, blockInfo){
            final /* synthetic */ BlockListActivity this$0;
            final /* synthetic */ BlockInfo $blockInfo;

            public boolean onMenuItemClick(@Nullable MenuItem item) {
                BlockCanary.INSTANCE.getBlockInfoRepository().delete(this.$blockInfo.getStartTime());
                List blocks = BlockCanary.INSTANCE.getBlockInfoRepository().listBlockInfo();
                HandlersKt.getMainHandler().post(new Runnable(this, blocks){
                    final /* synthetic */ onBlockLongClick.1 this$0;
                    final /* synthetic */ List $blocks;

                    public final void run() {
                        this.this$0.this$0.onBlocksRetrieved(this.$blocks);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$blocks = list;
                    }
                });
                return true;
            }
            {
                this.this$0 = this$0;
                this.$blockInfo = $captured_local_variable$1;
            }
        });
        popupMenu.show();
    }

    public static final /* synthetic */ void access$onBlockLongClick(BlockListActivity $this, View view, BlockInfo blockInfo) {
        $this.onBlockLongClick(view, blockInfo);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lblockcanary/ui/BlockListActivity$Companion;", "", "()V", "createPendingIntent", "Landroid/app/PendingIntent;", "context", "Landroid/content/Context;", "blockcanary-ui_release"})
    public static final class Companion {
        @NotNull
        public final PendingIntent createPendingIntent(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, BlockListActivity.class);
            intent.setFlags(0x14000000);
            int flags = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)flags);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"PendingIntent.getActivit\u2026        1, intent, flags)");
            return pendingIntent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

